/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.table;

import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.ColumnTypeManager;
import fi.csc.microarray.client.dataimport.ConversionModel;
import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.events.ColumnTitlesChangedEvent;
import fi.csc.microarray.client.dataimport.events.ConversionModelChangeListener;
import fi.csc.microarray.client.dataimport.events.DecimalSeparatorChangedEvent;
import fi.csc.microarray.client.dataimport.events.DelimiterChangedEvent;
import fi.csc.microarray.client.dataimport.events.FooterChangedEvent;
import fi.csc.microarray.client.dataimport.events.HeaderChangedEvent;
import fi.csc.microarray.client.dataimport.events.InputFileChangedEvent;
import fi.csc.microarray.client.dataimport.events.TitleRowChangedEvent;
import fi.csc.microarray.client.dataimport.table.EditableHeader;
import fi.csc.microarray.client.dataimport.table.EditableHeaderTableColumn;
import fi.csc.microarray.client.dataimport.table.PanelTableHeaderEditor;
import fi.csc.microarray.client.dataimport.table.PanelTableHeaderRenderer;
import fi.csc.microarray.client.dataimport.table.TableInternalFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

public class ImportPreviewTable
extends JXTable
implements MouseMotionListener,
MouseListener,
ConversionModelChangeListener {
    private static final Logger logger = Logger.getLogger(ImportPreviewTable.class);
    private static final int COLUMN_WIDTH = 120;
    private static final String HEADER_TOOLTIP = "Click to the row where the header ends";
    private static final String FOOTER_TOOLTIP = "Click to the row where the footer starts";
    private static final String TITLE_TOOLTIP = "Click to the column title row";
    private static final String NO_TOOL_DIALOG_TITLE = "Select a marking tool before clicking the table";
    private static final String NO_TOOL_DIALOG_TEXT = "No tool selected";
    private ConversionModel conversionModel;
    private ImportScreen screen;
    private TableInternalFrame tableFrame;
    private int header;
    private int footer;
    private boolean highlightRow;
    private boolean highlightColumn;
    private int mouseOverRow;
    private int mouseOverColumn;
    private int titles;
    private ColumnTypeManager columnTypeManager;
    private int defaultInitialDelay;
    private int defaultDismissDelay;
    private Point lastDragPoint;

    public ImportPreviewTable(ImportScreen importScreen, TableInternalFrame tableFrame) {
        this.screen = importScreen;
        this.conversionModel = importScreen.getConversionModel();
        this.tableFrame = tableFrame;
        this.columnTypeManager = this.screen.getColumnTypeManager();
        this.setAutoResizeMode(0);
        this.setSortable(false);
        this.setTableHeader(new EditableHeader(this.getColumnModel()));
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setEnabled(false);
        this.defaultInitialDelay = ToolTipManager.sharedInstance().getInitialDelay();
        this.defaultDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        this.setDefaultRenderer(String.class, new ImportCellRenderer());
        this.setDefaultRenderer(Double.class, new ImportCellRenderer());
        this.setDefaultRenderer(Integer.class, new RowNumberRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void createHeaderRenderers() {
        logger.debug("Check the header class of.." + this.getTableHeader() + "..");
        if (!(this.getTableHeader() instanceof EditableHeader)) {
            logger.debug("..not editable header, will put a new one");
            this.setTableHeader(new EditableHeader(this.getColumnModel()));
        }
        for (int i = 1; i < this.getColumnCount(); ++i) {
            if (this.getColumnModel().getColumn(i).getHeaderRenderer() instanceof PanelTableHeaderRenderer) continue;
            PanelTableHeaderRenderer renderer = new PanelTableHeaderRenderer(this.screen, i);
            this.getColumnModel().getColumn(i).setHeaderRenderer(renderer);
            if (!(this.getColumnModel().getColumn(i) instanceof EditableHeaderTableColumn)) {
                ((EditableHeader)this.getTableHeader()).recreateTableColumn(this.columnModel);
            }
            ((EditableHeaderTableColumn)this.getColumnModel().getColumn(i)).setHeaderEditor(new PanelTableHeaderEditor(renderer));
            this.getColumnModel().getColumn(i).setMinWidth(120);
        }
        this.screen.getTableFrame().updateAllChipCountComboBoxes();
        this.screen.getTableFrame().updateAllColumnTitleLabels();
        this.updateTableHeader();
    }

    public PanelTableHeaderRenderer getHeaderRenderer(int columnIndex) {
        return (PanelTableHeaderRenderer)this.getColumnModel().getColumn(columnIndex).getHeaderRenderer();
    }

    public void setData(Object[][] arrayData, String[] columnTitles) {
        try {
            class SetModelRunnable
            implements Runnable {
                private Object[][] arrayData;
                private String[] columnTitles;

                public SetModelRunnable(Object[][] arrayData, String[] columnTitles) {
                    this.arrayData = arrayData;
                    this.columnTitles = columnTitles;
                }

                public void run() {
                    ImportPreviewTable.this.setModel(new ImportPreviewTableModel(this.arrayData, this.columnTitles));
                    if (ImportPreviewTable.this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
                        ImportPreviewTable.this.screen.getTableFrame().addCornerComponents();
                    }
                }
            }
            SwingUtilities.invokeAndWait(new SetModelRunnable(arrayData, columnTitles));
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        class InitializeTableRunnable
        implements Runnable {
            InitializeTableRunnable() {
            }

            public void run() {
                if (ImportPreviewTable.this.screen.getCurrentStep() == ImportScreen.Step.SECOND) {
                    ImportPreviewTable.this.screen.getColumnTypeManager().setColumnCount(ImportPreviewTable.this.getColumnCount());
                    ImportPreviewTable.this.createHeaderRenderers();
                }
                if (!(ImportPreviewTable.this.screen.getConversionModel().hasColumnTitles() || ImportPreviewTable.this.screen.getConversionModel().hasFooter() || ImportPreviewTable.this.screen.getConversionModel().hasHeader())) {
                    ImportPreviewTable.this.initializeHeaderAndFooter();
                    ImportPreviewTable.this.tableFrame.resetSpinners();
                }
                ImportPreviewTable.this.updateRowNumberColumnWidth();
            }
        }
        SwingUtilities.invokeLater(new InitializeTableRunnable());
    }

    private void updateRowNumberColumnWidth() {
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            String str = this.getValueAt(this.getRowCount() - 1, 0).toString();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int width = SwingUtilities.computeStringWidth(fm, str) + 8;
            this.getColumnModel().getColumn(0).setMaxWidth(width);
            this.getColumnModel().getColumn(0).setMinWidth(width);
            logger.debug("Set row number column width to " + width);
        }
    }

    private void updateHighlight(MouseEvent e) {
        int oldMouseOverRow = this.mouseOverRow;
        int oldMouseOverColumn = this.mouseOverColumn;
        this.mouseOverRow = this.rowAtPoint(e.getPoint());
        this.mouseOverColumn = this.columnAtPoint(e.getPoint());
        if (this.mouseOverRow < 0 || this.mouseOverColumn < 0) {
            this.mouseOverRow = -1;
            this.mouseOverColumn = -1;
        }
        if (this.highlightRow && oldMouseOverRow != this.mouseOverRow || this.highlightColumn && oldMouseOverColumn != this.mouseOverColumn) {
            this.repaint();
        }
    }

    private void updateTableHeader() {
        DefaultTableColumnModelExt model = new DefaultTableColumnModelExt();
        String[] columnTitles = this.conversionModel.getColumnTitles();
        for (int column = 0; column < columnTitles.length && column < this.getColumnCount(); ++column) {
            TableColumn newColumn = this.getColumnModel().getColumn(column);
            if (column >= 1) {
                if (newColumn.getHeaderRenderer() instanceof PanelTableHeaderRenderer) {
                    ((PanelTableHeaderRenderer)newColumn.getHeaderRenderer()).setTitleText(columnTitles[column].toString());
                } else {
                    newColumn.setHeaderValue(columnTitles[column]);
                }
            }
            model.addColumn(newColumn);
        }
        this.setColumnModel(model);
        logger.debug("Table header updated");
    }

    public void setColumnHighlight(boolean enabled) {
        this.highlightColumn = enabled;
        this.repaint();
    }

    public void setRowHighlight(boolean enabled) {
        this.highlightRow = enabled;
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.updateHighlight(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.setTooltipDelays();
    }

    public void mouseExited(MouseEvent e) {
        this.updateHighlight(e);
        this.resetTooltipDelays();
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == this && this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            if (this.tableFrame.isInHeaderMarkingMode()) {
                this.markHeaderAtPoint(e.getPoint());
            } else if (this.tableFrame.isInFooterMarkingMode()) {
                this.markFooterAtPoint(e.getPoint());
            } else if (this.tableFrame.isInTitleMarkingMode()) {
                this.markTitleAtPoint(e.getPoint(), false);
            }
        } else {
            this.markColumnsBetweenPoints(this.lastDragPoint, e.getPoint());
            if (this.columnAtPoint(e.getPoint()) == -1) {
                return;
            }
            this.lastDragPoint = e.getPoint();
        }
        this.updateHighlight(e);
    }

    private void markColumnsBetweenPoints(Point start, Point end) {
        int smaller;
        int bigger;
        int startColumn = this.columnAtPoint(start);
        int endColumn = this.columnAtPoint(end);
        if (endColumn < 0) {
            endColumn = this.getColumnCount() - 2;
        }
        if (startColumn > endColumn) {
            bigger = startColumn;
            smaller = endColumn;
        } else {
            bigger = endColumn;
            smaller = startColumn;
        }
        for (int column = smaller; column <= bigger; ++column) {
            this.markColumn(column);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.lastDragPoint = e.getPoint();
        if (e.getSource() == this && this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            if (this.tableFrame.isInHeaderMarkingMode()) {
                this.markHeaderAtPoint(e.getPoint());
            } else if (this.tableFrame.isInFooterMarkingMode()) {
                this.markFooterAtPoint(e.getPoint());
            } else if (this.tableFrame.isInTitleMarkingMode()) {
                this.markTitleAtPoint(e.getPoint(), true);
            } else {
                JOptionPane.showMessageDialog(this.screen.getFrame(), NO_TOOL_DIALOG_TITLE, NO_TOOL_DIALOG_TEXT, 2);
            }
        } else if (e.getSource() == this && this.screen.getCurrentStep() == ImportScreen.Step.SECOND) {
            this.markColumnAtPoint(e.getPoint());
        }
    }

    private void markHeaderAtPoint(Point p) {
        int headerEnd = this.rowAtPoint(p);
        this.conversionModel.setHeaderEndsRow(headerEnd);
    }

    private void markFooterAtPoint(Point p) {
        int footerStart = this.rowAtPoint(p);
        this.conversionModel.setFooterBeginsRow(footerStart);
    }

    private void markTitleAtPoint(Point p, boolean removeIfSelected) {
        int columnTitleRow = this.rowAtPoint(p);
        if (this.titles == columnTitleRow && removeIfSelected) {
            this.conversionModel.setColumnTitleLine(-1);
        } else {
            this.conversionModel.setColumnTitleLine(columnTitleRow);
        }
        this.repaint();
    }

    private void markColumnAtPoint(Point p) {
        this.markColumn(this.columnAtPoint(p));
    }

    private void markColumn(int column) {
        if (this.screen.getTableFrame().getSelectedColumnType() != null) {
            ColumnType type = this.screen.getTableFrame().getSelectedColumnType();
            if (column >= 1 && column < this.screen.getColumnTypeManager().getColumnCount()) {
                this.screen.getColumnTypeManager().setColumnType(column, type, this.conversionModel.getCleanColumnTitle(column));
                this.screen.getColumnTypeManager().setColumnChipNumber(column, this.screen.getColumnTypeManager().getNextChipNumber(type));
            } else {
                logger.debug("ColumnCount smaller than clicked column index: " + this.screen.getColumnTypeManager().getColumnCount());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.repaint();
    }

    private void setHeaderEndRow(int header) {
        this.header = header;
        logger.debug("Header end row set to " + header);
        this.repaint();
    }

    private void setFooterStartRow(int footer) {
        if (footer < 0) {
            footer = this.getRowCount() + 1;
        }
        this.footer = footer;
        logger.debug("Footer start row set to " + footer);
        this.repaint();
    }

    private void setColumnTitleRow(int columnTitleRow) {
        this.titles = columnTitleRow;
        this.updateTableHeader();
        this.repaint();
    }

    public void initializeHeaderAndFooter() {
        this.header = -1;
        this.footer = this.getRowCount();
        this.titles = -1;
    }

    public void decimalSeparatorChanged(DecimalSeparatorChangedEvent e) {
    }

    public void delimiterChanged(DelimiterChangedEvent e) {
    }

    public void footerChanged(FooterChangedEvent e) {
        this.setFooterStartRow(e.getNewValue());
    }

    public void headerChanged(HeaderChangedEvent e) {
        this.setHeaderEndRow(e.getNewValue());
    }

    public void titleRowChanged(TitleRowChangedEvent e) {
        this.setColumnTitleRow(e.getNewValue());
    }

    public Point getToolTipLocation(MouseEvent event) {
        Point tooltipPoint = new Point(event.getX() + 12, event.getY() + 14);
        return tooltipPoint;
    }

    public String getToolTipText() {
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            if (this.screen.getTableFrame().isInFooterMarkingMode()) {
                return FOOTER_TOOLTIP;
            }
            if (this.screen.getTableFrame().isInHeaderMarkingMode()) {
                return HEADER_TOOLTIP;
            }
            if (this.screen.getTableFrame().isInTitleMarkingMode()) {
                return TITLE_TOOLTIP;
            }
            return null;
        }
        if (this.screen.getTableFrame().getSelectedColumnType() == null) {
            return null;
        }
        if (this.screen.getTableFrame().getSelectedColumnType().equals((Object)ColumnType.UNUSED_LABEL)) {
            return "Mark as unused";
        }
        return "Select " + this.screen.getTableFrame().getSelectedColumnType().toString().toLowerCase();
    }

    public void resetTooltipDelays() {
        ToolTipManager.sharedInstance().setInitialDelay(this.defaultInitialDelay);
        ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissDelay);
    }

    public void setTooltipDelays() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void columnTitlesChanged(ColumnTitlesChangedEvent e) {
    }

    public void inputFileChanged(InputFileChangedEvent e) {
    }

    class ImportCellRenderer
    extends DefaultTableCellRenderer {
        private int row;
        private int column;

        ImportCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.row = row;
            this.column = column;
            if (hasFocus) {
                Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
                this.setBorder(border);
            }
            if (ImportPreviewTable.this.highlightRow && row == ImportPreviewTable.this.mouseOverRow) {
                this.setBackground(new Color(250, 250, 250));
            } else if (ImportPreviewTable.this.highlightColumn && column == ImportPreviewTable.this.mouseOverColumn) {
                this.setBackground(new Color(250, 250, 250));
            } else {
                this.setBackground(UIManager.getColor("Table.background"));
            }
            return this;
        }

        protected void paintComponent(Graphics g) {
            if (ImportPreviewTable.this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
                this.setForeground(UIManager.getColor("Table.foreground"));
                if (ImportPreviewTable.this.header >= this.row) {
                    this.setForeground(Color.LIGHT_GRAY);
                }
                if (ImportPreviewTable.this.footer <= this.row) {
                    this.setForeground(Color.LIGHT_GRAY);
                }
                if (ImportPreviewTable.this.titles == this.row) {
                    this.setBackground(Color.LIGHT_GRAY);
                    this.setForeground(UIManager.getColor("Table.foreground"));
                }
            }
            this.setText(ImportPreviewTable.this.screen.getDataTrimmer().doTrimming(this.getText(), this.column));
            if (ImportPreviewTable.this.screen.getCurrentStep() == ImportScreen.Step.SECOND && ImportPreviewTable.this.columnTypeManager.getColumnCount() > this.column && ImportPreviewTable.this.columnTypeManager.getColumnType(this.column) != null && ImportPreviewTable.this.columnTypeManager.getColumnType(this.column).getColor() != null) {
                this.setForeground(UIManager.getColor("Table.foreground"));
                if (ImportPreviewTable.this.columnTypeManager.getColumnType(this.column).equals((Object)ColumnType.FLAG_LABEL) && ImportPreviewTable.this.screen.getToolsFrame().getFlagValuePanel().isFlagModificationEnabled() && ImportPreviewTable.this.columnTypeManager.getColumnType(this.column).equals((Object)ColumnType.FLAG_LABEL) && ImportPreviewTable.this.screen.getToolsFrame().getFlagValuePanel().isFlagModificationEnabled()) {
                    this.setText(ImportPreviewTable.this.screen.getFlagTrimmer().doTrimming(this.getText(), this.column));
                }
                this.setBackground(ImportPreviewTable.this.columnTypeManager.getColumnType(this.column).getColor());
            }
            super.paintComponent(g);
        }
    }

    class RowNumberRenderer
    extends DefaultTableCellRenderer {
        RowNumberRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (hasFocus) {
                Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
                this.setBorder(border);
            }
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImportPreviewTableModel
    extends AbstractTableModel {
        private String[] columnTitles;
        private Object[][] arrayData;

        public ImportPreviewTableModel(Object[][] arrayData, String[] columnTitles) {
            this.arrayData = arrayData;
            this.columnTitles = columnTitles;
        }

        @Override
        public int getRowCount() {
            return this.arrayData.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnTitles.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnTitles[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object firstValue = this.getValueAt(0, columnIndex);
            if (firstValue != null) {
                return firstValue.getClass();
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= 0 && row < this.arrayData.length && col >= 0 && col < this.arrayData[row].length) {
                return this.arrayData[row][col];
            }
            return "";
        }
    }
}

