/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.messaging.message.JobMessage;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisDescription {
    private static final Logger logger = Logger.getLogger(AnalysisDescription.class);
    private String command;
    private Object implementation;
    private String name;
    private String comment;
    private List<String> outputFiles = new LinkedList<String>();
    private List<ParameterDescription> parameters = new LinkedList<ParameterDescription>();
    private String sourceCode;
    private String category;
    private String vvsadl;
    private AnalysisHandler handler;
    private String sourceResourceName;
    private Date creationTime = new Date();

    public AnalysisDescription(AnalysisHandler handler) {
        this.handler = handler;
    }

    public String getCommand() {
        return this.command;
    }

    public AnalysisJob createAnalysisJob(JobMessage message, ResultCallback resultHandler) {
        return this.handler.createAnalysisJob(message, this, resultHandler);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    public Iterable<ParameterDescription> getParameters() {
        return this.parameters;
    }

    public void addParameter(ParameterDescription pd) {
        this.parameters.add(pd);
    }

    public static final String getStaticInitialiser() {
        return "";
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setImplementation(Object implementation) {
        this.implementation = implementation;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getFullName() {
        return "\"" + this.getCategory() + "\"/\"" + this.getName() + "\"";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addOutputFile(String file) {
        logger.debug("added output file " + file);
        this.outputFiles.add(file);
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void setVVSADL(String vvsadl) {
        this.vvsadl = vvsadl;
    }

    public String getVVSADL() {
        if (this.vvsadl != null) {
            return this.vvsadl;
        }
        return "ANALYSIS " + this.getFullName() + " (" + this.getComment() + ")";
    }

    public String getSourceResourceName() {
        return this.sourceResourceName;
    }

    public void setSourceResourceName(String sourceResourceName) {
        this.sourceResourceName = sourceResourceName;
    }

    public long getCreationTime() {
        return this.creationTime.getTime();
    }

    public boolean isUptodate() {
        return this.handler.isUptodate(this);
    }

    public static class ParameterDescription {
        private String name;
        private String comment;
        private boolean numeric;

        public ParameterDescription(String name, String comment, boolean numeric) {
            this.name = name;
            this.comment = comment;
            this.numeric = numeric;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public String getComment() {
            return this.comment;
        }

        public String getName() {
            return this.name;
        }
    }
}

