/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentReaderHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    protected final transient Object barrierLock = new Object();
    protected transient Object lastWrite;
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    protected final void recordModification(Object object) {
        Object object2 = this.barrierLock;
        synchronized (object2) {
            this.lastWrite = object;
        }
    }

    protected final Entry[] getTableForReading() {
        Object object = this.barrierLock;
        synchronized (object) {
            Entry[] entryArray = this.table;
            return entryArray;
        }
    }

    private int p2capacity(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            n2 = 4;
            while (n2 < n3) {
                n2 <<= 1;
            }
        }
        return n2;
    }

    private static int hash(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    public ConcurrentReaderHashMap(int n, float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        this.loadFactor = f;
        int n2 = this.p2capacity(n);
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f);
    }

    public ConcurrentReaderHashMap(int n) {
        this(n, 0.75f);
    }

    public ConcurrentReaderHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public ConcurrentReaderHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(Object object) {
        Entry entry;
        int n = ConcurrentReaderHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                entryArray = this.getTableForReading();
                if (entry == entryArray[n2]) {
                    return null;
                }
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                Object object2 = entry2.value;
                if (object2 != null) {
                    return object2;
                }
                ConcurrentReaderHashMap concurrentReaderHashMap = this;
                synchronized (concurrentReaderHashMap) {
                    entryArray = this.table;
                }
                n2 = n & entryArray.length - 1;
                entry2 = entry = entryArray[n2];
                continue;
            }
            entry2 = entry2.next;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n = ConcurrentReaderHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                ConcurrentReaderHashMap concurrentReaderHashMap = this;
                synchronized (concurrentReaderHashMap) {
                    entryArray = this.table;
                    if (entry == entryArray[n2]) {
                        Entry entry3;
                        entryArray[n2] = entry3 = new Entry(n, object, object2, entry);
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(entry3);
                        }
                        Object var10_13 = null;
                        return var10_13;
                    }
                    Object object3 = this.sput(object, object2, n);
                    return object3;
                }
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                ConcurrentReaderHashMap concurrentReaderHashMap = this;
                synchronized (concurrentReaderHashMap) {
                    entryArray = this.table;
                    Object object4 = entry2.value;
                    if (entry == entryArray[n2] && object4 != null) {
                        entry2.value = object2;
                        Object object5 = object4;
                        return object5;
                    }
                    Object object6 = this.sput(object, object2, n);
                    return object6;
                }
            }
            entry2 = entry2.next;
        }
    }

    protected Object sput(Object object, Object object2, int n) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                Entry entry3;
                entryArray[n2] = entry3 = new Entry(n, object, object2, entry);
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(entry3);
                }
                return null;
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                Object object3 = entry2.value;
                entry2.value = object2;
                return object3;
            }
            entry2 = entry2.next;
        }
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        if (n >= 0x40000000) {
            return;
        }
        int n2 = n << 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        int n3 = 0;
        while (n3 < n) {
            Entry entry = null;
            Entry entry2 = null;
            Entry entry3 = entryArray[n3];
            while (entry3 != null) {
                int n4 = entry3.hash;
                Entry entry4 = entry3.next;
                if ((n4 & n) == 0) {
                    if (entry == null && (entry4 == null || entry4.next == null && (entry4.hash & n) == 0)) {
                        entry = entry3;
                        break;
                    }
                    entry = new Entry(n4, entry3.key, entry3.value, entry);
                } else {
                    if (entry2 == null && (entry4 == null || entry4.next == null && (entry4.hash & n) != 0)) {
                        entry2 = entry3;
                        break;
                    }
                    entry2 = new Entry(n4, entry3.key, entry3.value, entry2);
                }
                entry3 = entry4;
            }
            entryArray2[n3] = entry;
            entryArray2[n + n3] = entry2;
            ++n3;
        }
        this.table = entryArray2;
        this.recordModification(entryArray2);
    }

    public Object remove(Object object) {
        Entry entry;
        int n = ConcurrentReaderHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (true) {
            if (entry2 == null) {
                entryArray = this.getTableForReading();
                if (entry == entryArray[n2]) {
                    return null;
                }
                return this.sremove(object, n);
            }
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                ConcurrentReaderHashMap concurrentReaderHashMap = this;
                synchronized (concurrentReaderHashMap) {
                    entryArray = this.table;
                    Object object2 = entry2.value;
                    if (entry != entryArray[n2] || object2 == null) {
                        Object object3 = this.sremove(object, n);
                        return object3;
                    }
                    entry2.value = null;
                    --this.count;
                    Entry entry3 = entry2.next;
                    Entry entry4 = entry;
                    while (entry4 != entry2) {
                        entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                        entry4 = entry4.next;
                    }
                    entryArray[n2] = entry3;
                    this.recordModification(entry3);
                    Object object4 = object2;
                    return object4;
                }
            }
            entry2 = entry2.next;
        }
    }

    protected Object sremove(Object object, int n) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            if (object == entry2.key || entry2.hash == n && object.equals(entry2.key)) {
                Object object2 = entry2.value;
                entry2.value = null;
                --this.count;
                Entry entry3 = entry2.next;
                Entry entry4 = entry;
                while (entry4 != entry2) {
                    entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                    entry4 = entry4.next;
                }
                entryArray[n2] = entry3;
                this.recordModification(entry3);
                return object2;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.getTableForReading();
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Object object2 = entry.value;
                if (object2 != null && object.equals(object2)) {
                    return true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public synchronized void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.put(k, v);
        }
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                entry.value = null;
                entry = entry.next;
            }
            entryArray[n] = null;
            ++n;
        }
        this.count = 0;
        this.recordModification(entryArray);
    }

    public synchronized Object clone() {
        try {
            ConcurrentReaderHashMap concurrentReaderHashMap = (ConcurrentReaderHashMap)super.clone();
            concurrentReaderHashMap.keySet = null;
            concurrentReaderHashMap.entrySet = null;
            concurrentReaderHashMap.values = null;
            Entry[] entryArray = this.table;
            Entry[] entryArray2 = concurrentReaderHashMap.table = new Entry[entryArray.length];
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                if (entry != null) {
                    entryArray2[n] = (Entry)entry.clone();
                }
                ++n;
            }
            return concurrentReaderHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new AbstractSet(){

            public Iterator iterator() {
                return new KeyIterator();
            }

            public int size() {
                return ConcurrentReaderHashMap.this.size();
            }

            public boolean contains(Object object) {
                return ConcurrentReaderHashMap.this.containsKey(object);
            }

            public boolean remove(Object object) {
                return ConcurrentReaderHashMap.this.remove(object) != null;
            }

            public void clear() {
                ConcurrentReaderHashMap.this.clear();
            }
        };
        return this.keySet;
    }

    public Collection values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new AbstractCollection(){

            public Iterator iterator() {
                return new ValueIterator();
            }

            public int size() {
                return ConcurrentReaderHashMap.this.size();
            }

            public boolean contains(Object object) {
                return ConcurrentReaderHashMap.this.containsValue(object);
            }

            public void clear() {
                ConcurrentReaderHashMap.this.clear();
            }
        };
        return this.values;
    }

    public Set entrySet() {
        Set set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new AbstractSet(){

            public Iterator iterator() {
                return new HashIterator();
            }

            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object object2 = ConcurrentReaderHashMap.this.get(k);
                return object2 != null && object2.equals(entry.getValue());
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return ConcurrentReaderHashMap.this.findAndRemoveEntry((Map.Entry)object);
            }

            public int size() {
                return ConcurrentReaderHashMap.this.size();
            }

            public void clear() {
                ConcurrentReaderHashMap.this.clear();
            }
        };
        return this.entrySet;
    }

    protected synchronized boolean findAndRemoveEntry(Map.Entry entry) {
        Object k = entry.getKey();
        Object object = this.get(k);
        if (object != null && object.equals(entry.getValue())) {
            this.remove(k);
            return true;
        }
        return false;
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    protected synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            Entry entry = this.table[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n;
        }
    }

    protected synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            ++n3;
        }
    }

    public synchronized int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        protected HashIterator() {
            this.tab = ConcurrentReaderHashMap.this.getTableForReading();
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object object = this.entry.value;
                    if (object != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = object;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return object;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReaderHashMap.this.remove(this.lastReturned.key);
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final int hash;
        protected final Object key;
        protected final Entry next;
        protected volatile Object value;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.next = entry;
            this.value = object2;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (!this.key.equals(entry.getKey())) {
                return false;
            }
            Object object2 = this.value;
            return object2 == null ? entry.getValue() == null : object2.equals(entry.getValue());
        }

        public int hashCode() {
            Object object = this.value;
            return this.hash ^ (object == null ? 0 : object.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

