/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicRequestor;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SimpleNetworkTest
extends TestCase {
    protected static final int MESSAGE_COUNT = 10;
    private static final Log LOG = LogFactory.getLog(SimpleNetworkTest.class);
    protected AbstractApplicationContext context;
    protected Connection localConnection;
    protected Connection remoteConnection;
    protected BrokerService localBroker;
    protected BrokerService remoteBroker;
    protected Session localSession;
    protected Session remoteSession;
    protected ActiveMQTopic included;
    protected ActiveMQTopic excluded;
    protected String consumerName = "durableSubs";

    public void testRequestReply() throws Exception {
        final MessageProducer remoteProducer = this.remoteSession.createProducer(null);
        MessageConsumer remoteConsumer = this.remoteSession.createConsumer((Destination)this.included);
        remoteConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    TextMessage textMsg = (TextMessage)msg;
                    String payload = "REPLY: " + textMsg.getText();
                    Destination replyTo = msg.getJMSReplyTo();
                    textMsg.clearBody();
                    textMsg.setText(payload);
                    remoteProducer.send(replyTo, (Message)textMsg);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
        TopicRequestor requestor = new TopicRequestor((TopicSession)this.localSession, (Topic)this.included);
        Thread.sleep(2000L);
        for (int i = 0; i < 10; ++i) {
            TextMessage msg = this.localSession.createTextMessage("test msg: " + i);
            TextMessage result = (TextMessage)requestor.request((Message)msg);
            SimpleNetworkTest.assertNotNull((Object)result);
            LOG.info((Object)result.getText());
        }
    }

    public void testFiltering() throws Exception {
        MessageConsumer includedConsumer = this.remoteSession.createConsumer((Destination)this.included);
        MessageConsumer excludedConsumer = this.remoteSession.createConsumer((Destination)this.excluded);
        MessageProducer includedProducer = this.localSession.createProducer((Destination)this.included);
        MessageProducer excludedProducer = this.localSession.createProducer((Destination)this.excluded);
        Thread.sleep(2000L);
        TextMessage test = this.localSession.createTextMessage("test");
        includedProducer.send((Message)test);
        excludedProducer.send((Message)test);
        SimpleNetworkTest.assertNull((Object)excludedConsumer.receive(1000L));
        SimpleNetworkTest.assertNotNull((Object)includedConsumer.receive(1000L));
    }

    public void xtestConduitBridge() throws Exception {
        MessageConsumer consumer1 = this.remoteSession.createConsumer((Destination)this.included);
        MessageConsumer consumer2 = this.remoteSession.createConsumer((Destination)this.included);
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        producer.setDeliveryMode(1);
        Thread.sleep(1000L);
        for (int i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
            SimpleNetworkTest.assertNotNull((Object)consumer1.receive(500L));
            SimpleNetworkTest.assertNotNull((Object)consumer2.receive(500L));
        }
        SimpleNetworkTest.assertNull((Object)consumer1.receive(500L));
        SimpleNetworkTest.assertNull((Object)consumer2.receive(500L));
    }

    public void xtestDurableStoreAndForward() throws Exception {
        int i;
        TopicSubscriber remoteConsumer = this.remoteSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        Thread.sleep(1000L);
        this.doTearDown();
        this.doSetUp();
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        for (i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
        }
        Thread.sleep(1000L);
        this.doTearDown();
        this.doSetUp();
        remoteConsumer = this.remoteSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        for (i = 0; i < 10; ++i) {
            SimpleNetworkTest.assertNotNull((Object)remoteConsumer.receive(500L));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.doSetUp();
    }

    protected void tearDown() throws Exception {
        this.localBroker.deleteAllMessages();
        this.remoteBroker.deleteAllMessages();
        this.doTearDown();
        super.tearDown();
    }

    protected void doTearDown() throws Exception {
        this.localConnection.close();
        this.remoteConnection.close();
        this.localBroker.stop();
        this.remoteBroker.stop();
    }

    protected void doSetUp() throws Exception {
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.start();
        this.localBroker = this.createLocalBroker();
        this.localBroker.start();
        URI localURI = this.localBroker.getVmConnectorURI();
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(localURI);
        this.localConnection = fac.createConnection();
        this.localConnection.setClientID("local");
        this.localConnection.start();
        URI remoteURI = this.remoteBroker.getVmConnectorURI();
        fac = new ActiveMQConnectionFactory(remoteURI);
        this.remoteConnection = fac.createConnection();
        this.remoteConnection.setClientID("remote");
        this.remoteConnection.start();
        this.included = new ActiveMQTopic("include.test.bar");
        this.excluded = new ActiveMQTopic("exclude.test.bar");
        this.localSession = this.localConnection.createSession(false, 1);
        this.remoteSession = this.remoteConnection.createSession(false, 1);
    }

    protected String getRemoteBrokerURI() {
        return "org/apache/activemq/network/remoteBroker.xml";
    }

    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker.xml";
    }

    protected BrokerService createBroker(String uri) throws Exception {
        ClassPathResource resource = new ClassPathResource(uri);
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        resource = new ClassPathResource(uri);
        factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService result = factory.getBroker();
        return result;
    }

    protected BrokerService createLocalBroker() throws Exception {
        return this.createBroker(this.getLocalBrokerURI());
    }

    protected BrokerService createRemoteBroker() throws Exception {
        return this.createBroker(this.getRemoteBrokerURI());
    }
}

