/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import javax.naming.Reference;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.jndi.JNDIReferenceFactory;
import org.apache.activemq.jndi.JNDIStorableInterface;

public class ObjectFactoryTest
extends CombinationTestSupport {
    public void testConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setDispatchAsync(true);
        factory.setBrokerURL("vm://test");
        factory.setClientID("test");
        factory.setCopyMessageOnSend(false);
        factory.setDisableTimeStampsByDefault(true);
        factory.setObjectMessageSerializationDefered(true);
        factory.setOptimizedMessageDispatch(false);
        factory.setPassword("pass");
        factory.setUseAsyncSend(true);
        factory.setUseCompression(true);
        factory.setUseRetroactiveConsumer(true);
        factory.setUserName("user");
        factory.getPrefetchPolicy().setQueuePrefetch(777);
        factory.getRedeliveryPolicy().setMaximumRedeliveries(15);
        factory.getRedeliveryPolicy().setBackOffMultiplier((short)32);
        Reference ref = JNDIReferenceFactory.createReference((String)factory.getClass().getName(), (JNDIStorableInterface)factory);
        JNDIReferenceFactory refFactory = new JNDIReferenceFactory();
        ActiveMQConnectionFactory temp = (ActiveMQConnectionFactory)refFactory.getObjectInstance((Object)ref, null, null, null);
        ObjectFactoryTest.assertEquals((boolean)factory.isDispatchAsync(), (boolean)temp.isDispatchAsync());
        ObjectFactoryTest.assertEquals((String)factory.getBrokerURL(), (String)temp.getBrokerURL());
        ObjectFactoryTest.assertEquals((String)factory.getClientID(), (String)temp.getClientID());
        ObjectFactoryTest.assertEquals((boolean)factory.isCopyMessageOnSend(), (boolean)temp.isCopyMessageOnSend());
        ObjectFactoryTest.assertEquals((boolean)factory.isDisableTimeStampsByDefault(), (boolean)temp.isDisableTimeStampsByDefault());
        ObjectFactoryTest.assertEquals((boolean)factory.isObjectMessageSerializationDefered(), (boolean)temp.isObjectMessageSerializationDefered());
        ObjectFactoryTest.assertEquals((boolean)factory.isOptimizedMessageDispatch(), (boolean)temp.isOptimizedMessageDispatch());
        ObjectFactoryTest.assertEquals((String)factory.getPassword(), (String)temp.getPassword());
        ObjectFactoryTest.assertEquals((boolean)factory.isUseAsyncSend(), (boolean)temp.isUseAsyncSend());
        ObjectFactoryTest.assertEquals((boolean)factory.isUseCompression(), (boolean)temp.isUseCompression());
        ObjectFactoryTest.assertEquals((boolean)factory.isUseRetroactiveConsumer(), (boolean)temp.isUseRetroactiveConsumer());
        ObjectFactoryTest.assertEquals((String)factory.getUserName(), (String)temp.getUserName());
        ObjectFactoryTest.assertEquals((int)factory.getPrefetchPolicy().getQueuePrefetch(), (int)temp.getPrefetchPolicy().getQueuePrefetch());
        ObjectFactoryTest.assertEquals((int)factory.getRedeliveryPolicy().getMaximumRedeliveries(), (int)temp.getRedeliveryPolicy().getMaximumRedeliveries());
        ObjectFactoryTest.assertEquals((short)factory.getRedeliveryPolicy().getBackOffMultiplier(), (short)temp.getRedeliveryPolicy().getBackOffMultiplier());
    }

    public void testDestination() throws Exception {
        ActiveMQQueue dest = new ActiveMQQueue();
        dest.setPhysicalName("TEST.FOO");
        Reference ref = JNDIReferenceFactory.createReference((String)dest.getClass().getName(), (JNDIStorableInterface)dest);
        JNDIReferenceFactory refFactory = new JNDIReferenceFactory();
        ActiveMQDestination temp = (ActiveMQDestination)refFactory.getObjectInstance((Object)ref, null, null, null);
        ObjectFactoryTest.assertEquals((String)dest.getPhysicalName(), (String)temp.getPhysicalName());
    }
}

