/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsQueueBrowserTest
extends JmsTestSupport {
    private static final Log LOG = LogFactory.getLog(JmsQueueBrowserTest.class);

    public void testReceiveBrowseReceive() throws Exception {
        Session session = this.connection.createSession(false, 0);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.start();
        Message[] outbound = new Message[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        while (consumer.receive(1000L) != null) {
        }
        producer.send(outbound[0]);
        producer.send(outbound[1]);
        producer.send(outbound[2]);
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], (Object)consumer.receive(1000L));
        consumer.close();
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueBrowserTest.assertTrue((String)"should have received the second message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[1], (Object)((Message)enumeration.nextElement()));
        JmsQueueBrowserTest.assertTrue((String)"Should have received the third message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[2], (Object)((Message)enumeration.nextElement()));
        boolean tooMany = false;
        while (enumeration.hasMoreElements()) {
            LOG.info((Object)("Got extra message: " + ((TextMessage)enumeration.nextElement()).getText()));
            tooMany = true;
        }
        JmsQueueBrowserTest.assertFalse((boolean)tooMany);
        browser.close();
        consumer = session.createConsumer((Destination)destination);
        JmsQueueBrowserTest.assertEquals((Object)outbound[1], (Object)consumer.receive(1000L));
        JmsQueueBrowserTest.assertEquals((Object)outbound[2], (Object)consumer.receive(1000L));
        consumer.close();
    }
}

