/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueueRepeaterTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(QueueRepeaterTest.class);
    private volatile String receivedText;
    private Session producerSession;
    private Session consumerSession;
    private Destination queue;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private Connection connection;
    private CountDownLatch latch = new CountDownLatch(1);

    public void testTransaction() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = factory.createConnection();
        this.queue = new ActiveMQQueue(((Object)((Object)this)).getClass().getName() + "." + this.getName());
        this.producerSession = this.connection.createSession(false, 1);
        this.consumerSession = this.connection.createSession(true, 0);
        this.producer = this.producerSession.createProducer(this.queue);
        this.consumer = this.consumerSession.createConsumer(this.queue);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                try {
                    TextMessage tm = (TextMessage)m;
                    QueueRepeaterTest.this.receivedText = tm.getText();
                    QueueRepeaterTest.this.latch.countDown();
                    LOG.info("consumer received message :" + QueueRepeaterTest.this.receivedText);
                    QueueRepeaterTest.this.consumerSession.commit();
                    LOG.info("committed transaction");
                }
                catch (JMSException e) {
                    try {
                        QueueRepeaterTest.this.consumerSession.rollback();
                        LOG.info("rolled back transaction");
                    }
                    catch (JMSException e1) {
                        LOG.info(e1);
                        e1.printStackTrace();
                    }
                    LOG.info(e);
                    e.printStackTrace();
                }
            }
        });
        this.connection.start();
        TextMessage tm = null;
        try {
            tm = this.producerSession.createTextMessage();
            tm.setText("Hello, " + new Date());
            this.producer.send(tm);
            LOG.info("producer sent message :" + tm.getText());
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        LOG.info("Waiting for latch");
        this.latch.await(2L, TimeUnit.SECONDS);
        QueueRepeaterTest.assertNotNull((Object)this.receivedText);
        LOG.info("test completed, destination=" + this.receivedText);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

