/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.activemq.kaha.impl.StoreLockedExcpetion;

public class StoreTest
extends TestCase {
    protected String name;
    protected Store store;

    public void testClose() throws Exception {
        this.store.close();
        try {
            this.store.getListContainer("fred");
            StoreTest.assertTrue((String)"Should have got a enception", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testClear() throws Exception {
        int count = 100;
        ListContainer list = this.store.getListContainer("testClear");
        list.load();
        for (int i = 0; i < count; ++i) {
            list.add("test " + i);
        }
        StoreTest.assertEquals((int)count, (int)list.size());
        this.store.clear();
        StoreTest.assertTrue((boolean)list.isEmpty());
    }

    public void testGetMapContainer() throws Exception {
        String containerId = "test";
        MapContainer container = this.store.getMapContainer(containerId);
        container.load();
        StoreTest.assertNotNull((Object)container);
        this.store.close();
        this.store = this.getStore();
        container = this.store.getMapContainer(containerId);
        StoreTest.assertNotNull((Object)container);
    }

    public void testDeleteMapContainer() throws Exception {
        String containerId = "test";
        MapContainer container = this.store.getMapContainer(containerId);
        StoreTest.assertNotNull((Object)container);
        this.store.deleteMapContainer(containerId);
        StoreTest.assertFalse((boolean)this.store.doesMapContainerExist(containerId));
        this.store.close();
        this.store = this.getStore();
        StoreTest.assertFalse((boolean)this.store.doesMapContainerExist(containerId));
    }

    public void testGetListContainer() throws Exception {
        String containerId = "test";
        ListContainer container = this.store.getListContainer(containerId);
        StoreTest.assertNotNull((Object)container);
        this.store.close();
        this.store = this.getStore();
        container = this.store.getListContainer(containerId);
        StoreTest.assertNotNull((Object)container);
    }

    public void testDeleteListContainer() throws Exception {
        String containerId = "test";
        ListContainer container = this.store.getListContainer(containerId);
        StoreTest.assertNotNull((Object)container);
        this.store.deleteListContainer(containerId);
        StoreTest.assertFalse((boolean)this.store.doesListContainerExist(containerId));
        this.store.close();
        this.store = this.getStore();
        StoreTest.assertFalse((boolean)this.store.doesListContainerExist(containerId));
    }

    public void testBasicAllocations() throws Exception {
        Object value;
        HashMap<String, String> testMap = new HashMap<String, String>();
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            String key = "key:" + i;
            String value2 = "value:" + i;
            testMap.put(key, value2);
        }
        ArrayList<String> testList = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            testList.add("value:" + i);
        }
        String listId = "testList";
        String mapId1 = "testMap";
        String mapId2 = "testMap2";
        MapContainer mapContainer1 = this.store.getMapContainer(mapId1);
        mapContainer1.load();
        mapContainer1.putAll(testMap);
        MapContainer mapContainer2 = this.store.getMapContainer(mapId2, mapId2);
        mapContainer2.load();
        mapContainer2.putAll(testMap);
        ListContainer listContainer = this.store.getListContainer(listId);
        listContainer.load();
        listContainer.addAll(testList);
        this.store.close();
        this.store = this.getStore();
        mapContainer1 = this.store.getMapContainer(mapId1);
        mapContainer1.load();
        mapContainer2 = this.store.getMapContainer(mapId2, mapId2);
        mapContainer2.load();
        listContainer = this.store.getListContainer(listId);
        listContainer.load();
        for (Object key : testMap.keySet()) {
            value = testMap.get(key);
            StoreTest.assertTrue((boolean)mapContainer1.containsKey(key));
            StoreTest.assertEquals(value, mapContainer1.get(key));
        }
        for (Object key : testMap.keySet()) {
            value = testMap.get(key);
            StoreTest.assertTrue((boolean)mapContainer2.containsKey(key));
            StoreTest.assertEquals(value, mapContainer2.get(key));
        }
        StoreTest.assertEquals((int)testList.size(), (int)listContainer.size());
        Iterator j = listContainer.iterator();
        Iterator i = testList.iterator();
        while (i.hasNext()) {
            StoreTest.assertEquals(i.next(), j.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLock() throws Exception {
        this.store.doesListContainerExist("fred");
        Store s = this.getStore();
        try {
            s.doesListContainerExist("fred");
        }
        catch (StoreLockedExcpetion e) {
            return;
        }
        finally {
            s.close();
        }
        StoreTest.fail((String)"Expected to catch an exception");
    }

    protected Store getStore() throws IOException {
        return StoreFactory.open(this.name, "rw");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/store-test.db";
        this.store = this.getStore();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        boolean rc = StoreFactory.delete(this.name);
        StoreTest.assertTrue((boolean)rc);
    }
}

