/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.converter;

import java.util.List;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.spring.ConsumerBean;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class InvokeMessageListenerTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;
    protected String startEndpointUri = "activemq:queue:test.a";
    protected ConsumerBean listener = new ConsumerBean();

    public void testSendTextMessage() throws Exception {
        String expectedBody = "Hello there!";
        this.template.sendBodyAndHeader(this.startEndpointUri, (Object)expectedBody, "cheese", (Object)123);
        this.listener.assertMessagesArrived(1);
        List<Message> list = this.listener.flushMessages();
        InvokeMessageListenerTest.assertTrue((String)"Should have received some messages!", (!list.isEmpty() ? 1 : 0) != 0);
        Message message = list.get(0);
        this.log.debug("Received: " + message);
        TextMessage textMessage = (TextMessage)this.assertIsInstanceOf(TextMessage.class, message);
        InvokeMessageListenerTest.assertEquals((String)("Text mesage body: " + textMessage), (String)expectedBody, (String)textMessage.getText());
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.addComponent("activemq", (Component)ActiveMQComponent.activeMQComponent("vm://localhost?broker.persistent=false"));
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(InvokeMessageListenerTest.this.startEndpointUri).bean((Object)InvokeMessageListenerTest.this.listener);
            }
        };
    }
}

