/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.camel.component.ActiveMQReplyToHeaderUsingConverterTest;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class InvokeRequestReplyUsingJmsReplyToHeaderTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(ActiveMQReplyToHeaderUsingConverterTest.class);
    protected String replyQueueName = "queue://test.reply";
    protected Object correlationID = "ABC-123";
    protected Object groupID = "GROUP-XYZ";
    private MyServer myBean = new MyServer();

    public void testPerformRequestReplyOverJms() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(new Object[]{"Hello James"});
        AssertionClause firstMessage = resultEndpoint.message(0);
        firstMessage.header("JMSCorrelationID").isEqualTo(this.correlationID);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("cheese", 123);
        headers.put("JMSReplyTo", this.replyQueueName);
        headers.put("JMSCorrelationID", this.correlationID);
        headers.put("JMSXGroupID", this.groupID);
        this.template.sendBodyAndHeaders("activemq:test.server", (Object)"James", headers);
        resultEndpoint.assertIsSatisfied();
        List list = resultEndpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        Message in = exchange.getIn();
        Object replyTo = in.getHeader("JMSReplyTo");
        LOG.info("Reply to is: " + replyTo);
        LOG.info("Received headers: " + in.getHeaders());
        LOG.info("Received body: " + in.getBody());
        this.assertMessageHeader(in, "JMSCorrelationID", this.correlationID);
        Map<String, Object> receivedHeaders = this.myBean.getHeaders();
        MatcherAssert.assertThat(receivedHeaders, (Matcher)Matchers.hasKey((Object)"JMSReplyTo"));
        MatcherAssert.assertThat(receivedHeaders, (Matcher)Matchers.hasEntry((Object)"JMSXGroupID", (Object)this.groupID));
        MatcherAssert.assertThat(receivedHeaders, (Matcher)Matchers.hasEntry((Object)"JMSCorrelationID", (Object)this.correlationID));
        replyTo = receivedHeaders.get("JMSReplyTo");
        LOG.info("Reply to is: " + replyTo);
        Destination destination = (Destination)this.assertIsInstanceOf(Destination.class, replyTo);
        InvokeRequestReplyUsingJmsReplyToHeaderTest.assertEquals((String)"ReplyTo", (String)this.replyQueueName, (String)destination.toString());
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.addComponent("activemq", (Component)ActiveMQComponent.activeMQComponent("vm://localhost?broker.persistent=false"));
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("activemq:test.server").bean((Object)InvokeRequestReplyUsingJmsReplyToHeaderTest.this.myBean);
                this.from("activemq:test.reply").to("mock:result");
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MyServer {
        private Map<String, Object> headers;

        protected MyServer() {
        }

        public String process(@Headers Map<String, Object> headers, String body) {
            this.headers = headers;
            LOG.info("process() invoked with headers: " + headers);
            return "Hello " + body;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }
    }
}

