/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MirroredQueueTest
extends EmbeddedBrokerTestSupport {
    private static final transient Log LOG = LogFactory.getLog(MirroredQueueTest.class);
    private Connection connection;

    public void testSendingToQueueIsMirrored() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList = new ConsumerBean();
        messageList.setVerbose(true);
        Destination consumeDestination = this.createConsumeDestination();
        Session session = this.connection.createSession(false, 1);
        LOG.info("Consuming from: " + consumeDestination);
        MessageConsumer c1 = session.createConsumer(consumeDestination);
        c1.setMessageListener(messageList);
        ActiveMQQueue sendDestination = new ActiveMQQueue(this.getQueueName());
        LOG.info("Sending to: " + sendDestination);
        MessageProducer producer = session.createProducer(sendDestination);
        MirroredQueueTest.assertNotNull((Object)producer);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            producer.send(session.createTextMessage("message: " + i));
        }
        messageList.assertMessagesArrived(total);
        LOG.info("Received: " + messageList);
    }

    public void testTempMirroredQueuesClearDown() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        Session session = this.connection.createSession(false, 0);
        TemporaryQueue tempQueue = session.createTemporaryQueue();
        RegionBroker rb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        MirroredQueueTest.assertTrue((rb.getDestinationMap().size() == 4 ? 1 : 0) != 0);
        tempQueue.delete();
        MirroredQueueTest.assertTrue((rb.getDestinationMap().size() == 3 ? 1 : 0) != 0);
    }

    protected Destination createConsumeDestination() {
        return new ActiveMQTopic("VirtualTopic.Mirror." + this.getQueueName());
    }

    protected String getQueueName() {
        return "My.Queue";
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseMirroredQueues(true);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

