/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.SequenceSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamResequencer
extends DelegateProcessor
implements Processor {
    private ResequencerEngine<Exchange> reseq;
    private BlockingQueue<Exchange> queue = new LinkedBlockingQueue<Exchange>();
    private SequenceSender sender;

    public StreamResequencer(Processor processor, SequenceElementComparator<Exchange> comparator, int capacity) {
        super(processor);
        this.reseq = new ResequencerEngine<Exchange>(comparator, capacity);
        this.reseq.setOutQueue(this.queue);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.sender = new SequenceSender(this.getProcessor());
        this.sender.setQueue(this.queue);
        this.sender.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.reseq.stop();
        this.sender.cancel();
        super.doStop();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.reseq.put(exchange);
    }

    public long getTimeout() {
        return this.reseq.getTimeout();
    }

    public void setTimeout(long timeout) {
        this.reseq.setTimeout(timeout);
    }

    @Override
    public String toString() {
        return "StreamResequencer[to: " + this.getProcessor() + "]";
    }
}

