/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.Exchange;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.processor.DelegateProcessor;

public class InstrumentationProcessor
extends DelegateProcessor {
    private PerformanceCounter counter;

    InstrumentationProcessor(PerformanceCounter counter) {
        this.counter = counter;
    }

    public void process(Exchange exchange) throws Exception {
        long startTime = System.nanoTime();
        super.process(exchange);
        if (this.counter != null) {
            if (exchange.getException() == null) {
                this.counter.completedExchange((System.nanoTime() - startTime) / 1000L);
            } else {
                this.counter.completedExchange();
            }
        }
    }
}

