/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PollingConsumerSupport<E extends Exchange>
extends ServiceSupport
implements PollingConsumer<E> {
    private final Endpoint<E> endpoint;
    private ExceptionHandler exceptionHandler;

    public PollingConsumerSupport(Endpoint<E> endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "PullConsumer on " + this.endpoint;
    }

    public Endpoint<E> getEndpoint() {
        return this.endpoint;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void handleException(Throwable t) {
        this.getExceptionHandler().handleException(t);
    }
}

