/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.component.file.strategy.DeleteFileProcessStrategy;
import org.apache.camel.component.file.strategy.NoOpFileProcessStrategy;
import org.apache.camel.component.file.strategy.RenameFileProcessStrategy;

public final class FileProcessStrategyFactory {
    private FileProcessStrategyFactory() {
    }

    public static FileProcessStrategy createFileProcessStrategy(boolean isNoop, boolean isDelete, boolean isLock, String moveNamePrefix, String moveNamePostfix) {
        if (isNoop) {
            return new NoOpFileProcessStrategy();
        }
        if (moveNamePostfix != null || moveNamePrefix != null) {
            if (isDelete) {
                throw new IllegalArgumentException("You cannot set the deleteFiles property and a moveFilenamePostfix or moveFilenamePrefix");
            }
            return new RenameFileProcessStrategy(isLock, moveNamePrefix, moveNamePostfix);
        }
        if (isDelete) {
            return new DeleteFileProcessStrategy(isLock);
        }
        return new RenameFileProcessStrategy(isLock);
    }
}

