/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectProducer<E extends Exchange>
extends DefaultProducer
implements AsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(DirectProducer.class);
    private DirectEndpoint<E> endpoint;

    public DirectProducer(DirectEndpoint<E> endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.endpoint.getConsumers().isEmpty()) {
            LOG.warn((Object)("No getConsumers() available on " + this + " for " + exchange));
        } else {
            for (DefaultConsumer<E> consumer : this.endpoint.getConsumers()) {
                consumer.getProcessor().process(exchange);
            }
        }
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        int size = this.endpoint.getConsumers().size();
        if (size == 0) {
            LOG.warn((Object)("No getConsumers() available on " + this + " for " + exchange));
        } else if (size > 1) {
            try {
                for (DefaultConsumer<E> consumer : this.endpoint.getConsumers()) {
                    consumer.getProcessor().process(exchange);
                }
            }
            catch (Throwable error) {
                exchange.setException(error);
            }
        } else {
            Iterator<DefaultConsumer<E>> i$ = this.endpoint.getConsumers().iterator();
            if (i$.hasNext()) {
                DefaultConsumer<E> consumer = i$.next();
                AsyncProcessor processor = AsyncProcessorTypeConverter.convert(consumer.getProcessor());
                return processor.process(exchange, callback);
            }
        }
        callback.done(true);
        return true;
    }
}

