/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.ProxyMessageStore;
import org.apache.activemq.store.ProxyTopicMessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;

public class MemoryTransactionStore
implements TransactionStore {
    ConcurrentHashMap<Object, Tx> inflightTransactions = new ConcurrentHashMap();
    ConcurrentHashMap<TransactionId, Tx> preparedTransactions = new ConcurrentHashMap();
    private boolean doingRecover;

    public MessageStore proxy(MessageStore messageStore) {
        return new ProxyMessageStore(messageStore){

            public void addMessage(ConnectionContext context, Message send) throws IOException {
                MemoryTransactionStore.this.addMessage(this.getDelegate(), send);
            }

            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MemoryTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }
        };
    }

    public TopicMessageStore proxy(TopicMessageStore messageStore) {
        return new ProxyTopicMessageStore(messageStore){

            public void addMessage(ConnectionContext context, Message send) throws IOException {
                MemoryTransactionStore.this.addMessage(this.getDelegate(), send);
            }

            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MemoryTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }
        };
    }

    public void prepare(TransactionId txid) {
        Tx tx = this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        this.preparedTransactions.put(txid, tx);
    }

    public Tx getTx(Object txid) {
        Tx tx = this.inflightTransactions.get(txid);
        if (tx == null) {
            tx = new Tx();
            this.inflightTransactions.put(txid, tx);
        }
        return tx;
    }

    public void commit(TransactionId txid, boolean wasPrepared) throws IOException {
        Tx tx = wasPrepared ? this.preparedTransactions.remove(txid) : this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        tx.commit();
    }

    public void rollback(TransactionId txid) {
        this.preparedTransactions.remove(txid);
        this.inflightTransactions.remove(txid);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recover(TransactionRecoveryListener listener) throws IOException {
        this.inflightTransactions.clear();
        this.doingRecover = true;
        try {
            for (Object txid : this.preparedTransactions.keySet()) {
                Tx tx = this.preparedTransactions.get(txid);
                listener.recover((XATransactionId)txid, tx.getMessages(), tx.getAcks());
            }
        }
        finally {
            this.doingRecover = false;
        }
    }

    void addMessage(final MessageStore destination, final Message message) throws IOException {
        if (this.doingRecover) {
            return;
        }
        if (message.getTransactionId() != null) {
            Tx tx = this.getTx(message.getTransactionId());
            tx.add(new AddMessageCommand(){

                public Message getMessage() {
                    return message;
                }

                public void run() throws IOException {
                    destination.addMessage(null, message);
                }
            });
        } else {
            destination.addMessage(null, message);
        }
    }

    final void removeMessage(final MessageStore destination, final MessageAck ack) throws IOException {
        if (this.doingRecover) {
            return;
        }
        if (ack.isInTransaction()) {
            Tx tx = this.getTx(ack.getTransactionId());
            tx.add(new RemoveMessageCommand(){

                public MessageAck getMessageAck() {
                    return ack;
                }

                public void run() throws IOException {
                    destination.removeMessage(null, ack);
                }
            });
        } else {
            destination.removeMessage(null, ack);
        }
    }

    public void delete() {
        this.inflightTransactions.clear();
        this.preparedTransactions.clear();
        this.doingRecover = false;
    }

    public static interface RemoveMessageCommand {
        public MessageAck getMessageAck();

        public void run() throws IOException;
    }

    public static interface AddMessageCommand {
        public Message getMessage();

        public void run() throws IOException;
    }

    public static class Tx {
        private ArrayList<AddMessageCommand> messages = new ArrayList();
        private ArrayList<RemoveMessageCommand> acks = new ArrayList();

        public void add(AddMessageCommand msg) {
            this.messages.add(msg);
        }

        public void add(RemoveMessageCommand ack) {
            this.acks.add(ack);
        }

        public Message[] getMessages() {
            Message[] rc = new Message[this.messages.size()];
            int count = 0;
            for (AddMessageCommand cmd : this.messages) {
                rc[count++] = cmd.getMessage();
            }
            return rc;
        }

        public MessageAck[] getAcks() {
            MessageAck[] rc = new MessageAck[this.acks.size()];
            int count = 0;
            for (RemoveMessageCommand cmd : this.acks) {
                rc[count++] = cmd.getMessageAck();
            }
            return rc;
        }

        public void commit() throws IOException {
            for (AddMessageCommand addMessageCommand : this.messages) {
                addMessageCommand.run();
            }
            for (RemoveMessageCommand removeMessageCommand : this.acks) {
                removeMessageCommand.run();
            }
        }
    }
}

