/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.lang.reflect.Constructor;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.component.jms.JmsConfiguration;
import org.springframework.jms.connection.SingleConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQConfiguration
extends JmsConfiguration {
    private String brokerURL = "failover://tcp://localhost:61616";
    private boolean useSingleConnection = false;
    private boolean usePooledConnection = true;

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public boolean isUseSingleConnection() {
        return this.useSingleConnection;
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        this.useSingleConnection = useSingleConnection;
    }

    public boolean isUsePooledConnection() {
        return this.usePooledConnection;
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        this.usePooledConnection = usePooledConnection;
    }

    protected ConnectionFactory createConnectionFactory() {
        org.apache.activemq.spring.ActiveMQConnectionFactory answer = new org.apache.activemq.spring.ActiveMQConnectionFactory();
        if (answer.getBeanName() == null) {
            answer.setBeanName("Camel");
        }
        answer.setBrokerURL(this.getBrokerURL());
        if (this.isUseSingleConnection()) {
            return new SingleConnectionFactory((ConnectionFactory)answer);
        }
        if (this.isUsePooledConnection()) {
            return this.createPooledConnectionFactory(answer);
        }
        return answer;
    }

    protected ConnectionFactory createPooledConnectionFactory(org.apache.activemq.spring.ActiveMQConnectionFactory connectionFactory) {
        try {
            Class<?> type = ActiveMQConfiguration.loadClass("org.apache.activemq.pool.PooledConnectionFactory", ((Object)((Object)this)).getClass().getClassLoader());
            Constructor<?> constructor = type.getConstructor(ActiveMQConnectionFactory.class);
            return (ConnectionFactory)constructor.newInstance(connectionFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate PooledConnectionFactory: " + e, e);
        }
    }

    public static Class<?> loadClass(String name, ClassLoader loader) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return loader.loadClass(name);
            }
        }
        return null;
    }
}

