/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.description.ParsedVVSADL;
import fi.csc.microarray.description.VVSADLParser;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import java.util.List;

public class ChipsterVVSADLParser
extends VVSADLParser {
    public ChipsterVVSADLParser() {
        this(null);
    }

    public ChipsterVVSADLParser(String filename) {
        super(filename);
        this.addInputType(ChipsterInputTypes.AFFY);
        this.addInputType(ChipsterInputTypes.CDNA);
        this.addInputType(ChipsterInputTypes.GENE_EXPRS);
        this.addInputType(ChipsterInputTypes.GENELIST);
        this.addInputType(ChipsterInputTypes.PHENODATA);
    }

    public static class Validator {
        public void validate(String filename, String vvsadl) throws VVSADLParser.ParseException {
            ChipsterVVSADLParser parser = new ChipsterVVSADLParser(filename);
            List<ParsedVVSADL> descriptions = parser.parseMultiple(vvsadl);
            for (ParsedVVSADL description : descriptions) {
                this.checkParsedContent(description);
            }
        }

        private void checkParsedContent(ParsedVVSADL description) {
            for (ParsedVVSADL.Parameter parameter : description.parameters()) {
                if (parameter.getType() != VVSADLSyntax.ParameterType.ENUM) continue;
                if (parameter.getSelectionOptions() == null || parameter.getSelectionOptions().length == 0) {
                    throw new RuntimeException("enum parameter " + parameter.getName() + " has no options");
                }
                if (parameter.getDefaultValue() == null) continue;
                boolean found = false;
                for (String value : parameter.getSelectionOptions()) {
                    if (!parameter.getDefaultValue().equals(value)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new RuntimeException("enum parameter " + parameter.getName() + " has undefined default value \"" + parameter.getDefaultValue() + "\"");
            }
        }
    }
}

