/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.util.MemUtil;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.h2.tools.Server;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class Manager
extends MonitoredNodeBase
implements MessagingListener {
    private final Logger logger = Logger.getLogger(Manager.class);
    private JdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertJobTemplate;
    private static final String CREATE_JOBS_TABLE = "CREATE TABLE IF NOT EXISTS jobs (id VARCHAR(100) PRIMARY KEY, operation VARCHAR(100), status VARCHAR(20), starttime DATETIME DEFAULT NULL, endtime DATETIME DEFAULT NULL, wallclockTime INT DEFAULT NULL, errorMessage TEXT DEFAULT NULL, outputText TEXT DEFAULT NULL, username VARCHAR(20), compHost VARCHAR(50)); ";
    private MessagingEndpoint endpoint;

    public Manager() throws MicroarrayException, JMSException, IOException, ConfigurationLoader.OldConfigurationFormatException, ClassNotFoundException, SQLException {
        this.logger.info((Object)"Starting manager...");
        String dbDriver = MicroarrayConfiguration.getValue("manager", "jdbcDriver");
        String dbUrl = MicroarrayConfiguration.getValue("manager", "databaseUrl");
        boolean startWebConsole = "true".equals(MicroarrayConfiguration.getValue("manager", "startWebConsole"));
        String dbUsername = MicroarrayConfiguration.getValue("manager", "databaseUsername");
        String dbPassword = MicroarrayConfiguration.getValue("manager", "databasePassword");
        int webConsolePort = Integer.parseInt(MicroarrayConfiguration.getValue("manager", "webConsolePort"));
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(dbDriver);
        dataSource.setUrl(dbUrl);
        dataSource.setUsername(dbUsername);
        dataSource.setPassword(dbPassword);
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        this.insertJobTemplate = new SimpleJdbcInsert((DataSource)dataSource).withTableName("jobs");
        this.jdbcTemplate.execute(CREATE_JOBS_TABLE);
        String backupDirName = MicroarrayConfiguration.getValue("manager", "backupDir");
        int backupInterval = Integer.parseInt(MicroarrayConfiguration.getValue("manager", "backupInterval"));
        String backupTimeString = MicroarrayConfiguration.getValue("manager", "backupTime");
        int startHour = Integer.parseInt(backupTimeString.split(":")[0]);
        int startMinute = Integer.parseInt(backupTimeString.split(":")[1]);
        Calendar firstBackupTime = Calendar.getInstance();
        if (firstBackupTime.get(11) > startHour || firstBackupTime.get(11) == startHour && firstBackupTime.get(12) >= startMinute) {
            firstBackupTime.add(5, 1);
        }
        firstBackupTime.set(11, startHour);
        firstBackupTime.set(12, startMinute);
        firstBackupTime.set(13, 0);
        firstBackupTime.set(14, 0);
        this.logger.info((Object)("Next database backup is scheduled at " + firstBackupTime.getTime().toString()));
        Timer timer = new Timer("chipster-manager-backup", true);
        timer.scheduleAtFixedRate((TimerTask)new BackupTimerTask(backupDirName), firstBackupTime.getTime(), (long)(backupInterval * 60 * 60 * 1000));
        this.endpoint = new MessagingEndpoint(this);
        MessagingTopic managerTopic = this.endpoint.createTopic(Topics.Name.MANAGER_TOPIC, MessagingTopic.AccessMode.READ);
        managerTopic.setListener(this);
        if (startWebConsole) {
            Server server = Server.createWebServer((String[])new String[]{"-webAllowOthers", "-webPort", String.valueOf(webConsolePort)});
            server.start();
        }
        this.logger.error((Object)("manager is up and running [" + ApplicationConstants.NAMI_VERSION + "]"));
        this.logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
    }

    public String getName() {
        return "manager";
    }

    public void onNamiMessage(NamiMessage namiMessage) {
        if (!(namiMessage instanceof JobLogMessage)) {
            this.logger.warn((Object)("Got other than JobLogMessage: " + namiMessage.toString()));
            return;
        }
        JobLogMessage jobLogMessage = (JobLogMessage)namiMessage;
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("id", jobLogMessage.getJobId());
            parameters.put("operation", jobLogMessage.getOperation());
            parameters.put("status", jobLogMessage.getState().toString());
            parameters.put("starttime", jobLogMessage.getStartTime());
            parameters.put("endtime", jobLogMessage.getEndTime());
            parameters.put("wallclockTime", (jobLogMessage.getEndTime().getTime() - jobLogMessage.getStartTime().getTime()) / 1000L);
            parameters.put("errorMessage", jobLogMessage.getErrorMessage());
            parameters.put("outputText", jobLogMessage.getOutputText());
            parameters.put("username", jobLogMessage.getUsername());
            parameters.put("compHost", jobLogMessage.getCompHost());
            this.insertJobTemplate.execute(parameters);
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not insert log entry", (Throwable)e);
        }
    }

    private class BackupTimerTask
    extends TimerTask {
        private String baseBackupDirName;

        public BackupTimerTask(String baseBackupDirName) {
            this.baseBackupDirName = baseBackupDirName;
        }

        public void run() {
            Manager.this.logger.info((Object)"Creating database backup");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_mm:ss.SSS");
            String fileName = this.baseBackupDirName + File.separator + "chipster-manager-db-backup-" + df.format(new Date());
            String sql = "SCRIPT TO '" + fileName + ".zip' COMPRESSION ZIP";
            Manager.this.jdbcTemplate.execute(sql);
        }
    }
}

