/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.PositionRecordingRenderer;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.OverlayLayout;

public class Volcanoplot
extends Scatterplot
implements ActionListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private static final String COLUMN_MASK = "***";
    private static final String Y_AXIS_CONVERTER = "neg(log(***))";
    private static final String Y_AXIS_COLUMN_HEADER = "p.";
    private static final String X_AXIS_COLUMN_HEADER = "FC";

    public Volcanoplot(VisualisationFrame frame) {
        super(frame);
    }

    public JPanel createSettingsPanel() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.xBox = new JComboBox();
        this.yBox = new JComboBox();
        this.useButton = new JButton("Draw");
        this.useButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 10, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.settingsPanel.add((Component)new JLabel("Fold change "), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.xBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)new JLabel("p-value"), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.yBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.useButton, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.settingsPanel.add((Component)new JPanel(), c);
        this.xBox.addActionListener(this);
        this.yBox.addActionListener(this);
        return this.settingsPanel;
    }

    protected void refreshAxisBoxes(DataBean data) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        Visualisation.fillCompoBox(this.xBox, VisualisationUtilities.getVariablesFiltered(data, X_AXIS_COLUMN_HEADER, false));
        Visualisation.fillCompoBox(this.yBox, VisualisationUtilities.getVariablesFiltered(data, Y_AXIS_COLUMN_HEADER, false));
    }

    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        if (this.chartPanel != null) {
            this.chartPanel.setVisible(false);
        }
        this.allItems.clear();
        this.refreshAxisBoxes(data);
        List<Visualisation.Variable> vars = this.getFrame().getVariables();
        if (vars != null && vars.size() == 2) {
            this.xBox.setSelectedItem(vars.get(0));
            this.yBox.setSelectedItem(vars.get(1));
        }
        Visualisation.Variable xVar = (Visualisation.Variable)this.xBox.getSelectedItem();
        Visualisation.Variable yVar = (Visualisation.Variable)this.yBox.getSelectedItem();
        Iterator<Float> xValues = data.queryFeatures(xVar.getExpression()).asFloats().iterator();
        Iterator<Float> yValues = data.queryFeatures(Y_AXIS_CONVERTER.replace(COLUMN_MASK, yVar.getExpression())).asFloats().iterator();
        XYSeries greenSeries = new XYSeries((Comparable)((Object)""), false);
        XYSeries blackSeries = new XYSeries((Comparable)((Object)""), false);
        XYSeries redSeries = new XYSeries((Comparable)((Object)""), false);
        int row = 0;
        for (String name : data.queryFeatures("/identifier").asStrings()) {
            int index;
            int series;
            boolean overXThreshold;
            float x = xValues.next().floatValue();
            float y = yValues.next().floatValue();
            boolean overYThreshold = (double)y >= -Math.log(0.05);
            boolean bl = overXThreshold = Math.abs(x) >= 1.0f;
            if (overYThreshold && overXThreshold) {
                if (x < 0.0f) {
                    series = 0;
                    index = greenSeries.getItemCount();
                    greenSeries.add(new XYDataItem((double)x, (double)y));
                } else {
                    series = 1;
                    index = redSeries.getItemCount();
                    redSeries.add(new XYDataItem((double)x, (double)y));
                }
            } else {
                series = 2;
                index = blackSeries.getItemCount();
                blackSeries.add(new XYDataItem((double)x, (double)y));
            }
            this.allItems.add(new Scatterplot.DataItem2D(null, name, row, index, series));
            ++row;
        }
        Visualisation.PlotDescription description = new Visualisation.PlotDescription(data.getName(), "fold change", "-log(p)");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(greenSeries);
        dataset.addSeries(redSeries);
        dataset.addSeries(blackSeries);
        NumberAxis domainAxis = new NumberAxis(description.xTitle);
        NumberAxis rangeAxis = new NumberAxis(description.yTitle);
        rangeAxis.setRange(new Range(0.0, 16.0));
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, null);
        JFreeChart chart = new JFreeChart(description.plotTitle, (Plot)plot);
        this.chartPanel = this.makePanel(chart);
        this.chartPanel.addMouseListener((MouseListener)this);
        this.chartPanel.addMouseMotionListener((MouseMotionListener)this);
        this.chartPanel.setMouseZoomable(false);
        PositionRecordingRenderer renderer = new PositionRecordingRenderer(1, this.allItems, this.selectedItems, this.chartPanel);
        renderer.setSeriesPaint(0, Color.green);
        renderer.setSeriesPaint(1, Color.red);
        renderer.setSeriesPaint(2, Color.black);
        renderer.setShape(new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        plot.setRenderer((XYItemRenderer)renderer);
        this.overlayPanel = new JPanel((LayoutManager)new OverlayLayout());
        this.transparentPanel = new Scatterplot.TransparentPanel();
        this.overlayPanel.add(this.transparentPanel);
        this.overlayPanel.add((Component)this.chartPanel);
        this.updateSelectionsFromApplication(false);
        this.application.addPropertyChangeListener(this);
        this.chartPanel.setVisible(true);
        return this.overlayPanel;
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        return isTabular && this.hasRows(bean) && bean.queryFeatures(Y_AXIS_CONVERTER.replace(COLUMN_MASK, "/column/p.*")).exists() && bean.queryFeatures("/column/FC*").exists();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useButton) {
            ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
            vars.add((Visualisation.Variable)this.xBox.getSelectedItem());
            vars.add((Visualisation.Variable)this.yBox.getSelectedItem());
            this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.VOLCANOPLOT, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
        }
    }
}

