/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.awt.Color;
import java.awt.Paint;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.DefaultCategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionProfile
extends Visualisation {
    private static final float START_COLOR_R = 0.0f;
    private static final float START_COLOR_G = 0.0f;
    private static final float START_COLOR_B = 1.0f;
    private static final float MIDDLE_COLOR_R = 1.0f;
    private static final float MIDDLE_COLOR_G = 1.0f;
    private static final float MIDDLE_COLOR_B = 0.0f;
    private static final float END_COLOR_R = 1.0f;
    private static final float END_COLOR_G = 0.0f;
    private static final float END_COLOR_B = 0.0f;

    public ExpressionProfile(VisualisationFrame frame) {
        super(frame);
    }

    private static Color getColor(float position) {
        float b;
        float g;
        float r;
        boolean beforeMiddle = position < 0.5f;
        float gradientPosition = beforeMiddle ? position * 2.0f : (position - 0.5f) * 2.0f;
        float invGradientPosition = 1.0f - gradientPosition;
        if (beforeMiddle) {
            r = 0.0f * invGradientPosition + 1.0f * gradientPosition;
            g = 0.0f * invGradientPosition + 1.0f * gradientPosition;
            b = 1.0f * invGradientPosition + 0.0f * gradientPosition;
        } else {
            r = 1.0f * invGradientPosition + 1.0f * gradientPosition;
            g = 1.0f * invGradientPosition + 0.0f * gradientPosition;
            b = 0.0f * invGradientPosition + 0.0f * gradientPosition;
        }
        return new Color(r, g, b);
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        TableAnnotationProvider annotationProvider = new TableAnnotationProvider(data);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Table samples = data.queryFeatures("/column/*").asTable();
        LinkedList<ProfileRow> rows = new LinkedList<ProfileRow>();
        int rowNumber = 0;
        while (samples.nextRow()) {
            boolean firstSample = true;
            for (String sample : samples.getColumnNames()) {
                if (!sample.startsWith("chip.")) continue;
                if (firstSample) {
                    ProfileRow row = new ProfileRow();
                    row.value = Float.valueOf(samples.getFloatValue(sample));
                    row.series = rowNumber;
                    firstSample = false;
                    rows.add(row);
                }
                String sampleName = data.queryFeatures("/phenodata/linked/sample_to_name/" + sample.substring("chip.".length())).asString();
                String rowName = annotationProvider.getAnnotatedRowname(samples.getStringValue(" "));
                IndividualizedColumn column = new IndividualizedColumn(sample, sampleName);
                dataset.addValue((double)samples.getFloatValue(sample), (Comparable)((Object)rowName), (Comparable)column);
            }
            ++rowNumber;
        }
        JFreeChart chart = ExpressionProfile.createProfileChart(dataset, rows, data.getName());
        return this.makePanel(chart);
    }

    public static JFreeChart createProfileChart(DefaultCategoryDataset dataset, LinkedList<ProfileRow> rows, String name) {
        DefaultCategoryItemRenderer renderer = new DefaultCategoryItemRenderer();
        renderer.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setShapesVisible(false);
        Collections.sort(rows);
        float position = 0.0f;
        float step = 1.0f / (float)rows.size();
        for (ProfileRow row : rows) {
            row.color = ExpressionProfile.getColor(position);
            renderer.setSeriesPaint(row.series, (Paint)ExpressionProfile.getColor(position));
            position += step;
        }
        CategoryAxis categoryAxis = new CategoryAxis("sample");
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        NumberAxis valueAxis = new NumberAxis("expression");
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Expression profile for " + name, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        return chart;
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        if (isTabular) {
            Table chips = bean.queryFeatures("/column/chip.*").asTable();
            return chips != null && chips.getColumnNames().length > 1;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndividualizedColumn
    implements Comparable<IndividualizedColumn> {
        private String viewName;
        private String internalName;

        public IndividualizedColumn(String internalName, String viewName) {
            this.internalName = internalName;
            this.viewName = viewName;
        }

        @Override
        public int compareTo(IndividualizedColumn o) {
            return this.internalName.compareTo(o.internalName);
        }

        public String toString() {
            return this.viewName;
        }

        public boolean equals(Object o) {
            if (o instanceof IndividualizedColumn) {
                IndividualizedColumn ic = (IndividualizedColumn)o;
                return this.internalName.equals(ic.internalName);
            }
            return false;
        }

        public int hashCode() {
            return this.internalName.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProfileRow
    implements Comparable<ProfileRow> {
        int series;
        Float value;
        Color color;

        @Override
        public int compareTo(ProfileRow row) {
            return this.value.compareTo(row.value);
        }
    }
}

