/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.util.FloatArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicTimeSeries {
    private JPanel panel;
    private List<TimeSeries> serieses = new LinkedList<TimeSeries>();

    public DynamicTimeSeries(List<String> seriesNames, int historyCount, String title) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (String name : seriesNames) {
            TimeSeries ts = new TimeSeries(name, Millisecond.class);
            ts.setMaximumItemCount(historyCount);
            dataset.addSeries(ts);
            this.serieses.add(ts);
        }
        DateAxis domain = new DateAxis("Time");
        NumberAxis range = new NumberAxis(title);
        domain.setTickLabelsVisible(true);
        domain.setAutoRange(true);
        range.setAutoRange(true);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.RED);
        renderer.setStroke((Stroke)new BasicStroke(3.0f, 0, 2));
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domain, (ValueAxis)range, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart(title, new Font("SansSerif", 1, 23), (Plot)plot, true);
        this.panel = new ChartPanel(chart);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void addTimePoint(FloatArrayList values) {
        assert (values.size() == this.serieses.size());
        int i = 0;
        for (TimeSeries ts : this.serieses) {
            ts.add((RegularTimePeriod)new Millisecond(), (Number)values.get(i));
            ++i;
        }
    }
}

