/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dataimport.ActionChooserScreen;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.RunnableImportProcess;
import fi.csc.microarray.client.dataimport.table.InformationDialog;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportUtils {
    private static final Logger logger = Logger.getLogger(ImportUtils.class);
    private static final String DEFAULT_FOLDER_NAME = "My experiment";
    private static ClientApplication application = Session.getSession().getApplication();
    private static boolean zipDialogShown = false;

    public static JFileChooser getFixedFileChooser() {
        return ImportUtils.getFixedFileChooser(null);
    }

    public static JFileChooser getFixedFileChooser(File file) {
        boolean hasZipFolderSupport;
        String osName = System.getProperty("os.name");
        boolean bl = hasZipFolderSupport = osName.contains("Windows XP") || osName.contains("Windows NT (unknown)") || osName.contains("Windows Vista");
        if (hasZipFolderSupport && !zipDialogShown) {
            File[] roots;
            boolean zipsOnDesktop = false;
            for (File root : roots = FileSystemView.getFileSystemView().getRoots()) {
                String[] zips = root.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        String lcName = name.toLowerCase();
                        return lcName.endsWith(".zip");
                    }
                });
                if (zips.length <= 0) continue;
                zipsOnDesktop = true;
                break;
            }
            if (zipsOnDesktop) {
                DialogInfo info = new DialogInfo(DialogInfo.Severity.INFO, "ZIP files detected", "There seems to be ZIP files on your desktop. This can slow down selecting files in some Windows versions. If you experience this problem, please move the ZIP files to a subfolder.", null, DialogInfo.Type.OK_MESSAGE);
                ChipsterDialog.showDialog(null, info, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, true, null);
                zipDialogShown = true;
            }
        }
        JFileChooser fileChooser = file != null ? new JFileChooser(file) : new JFileChooser();
        fileChooser.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        return fileChooser;
    }

    public static Set<String> getFolderNames(boolean includeDefaultFolder) {
        HashSet<String> folderNameList = new HashSet<String>();
        DataFolder root = application.getDataManager().getRootFolder();
        for (DataItem item : root.getChildren()) {
            if (!(item instanceof DataFolder)) continue;
            folderNameList.add(item.getName());
        }
        if (includeDefaultFolder) {
            folderNameList.add(DEFAULT_FOLDER_NAME);
        }
        return folderNameList;
    }

    public static URLFileLoader getURLFileLoader() {
        return new URLFileLoader();
    }

    public static File createTempFile(String name, String ext) throws IOException {
        File file = File.createTempFile(name, ext);
        file.deleteOnExit();
        return file;
    }

    public static boolean containsUnsupportedTypes(File[] files) {
        boolean isUnsupported = false;
        for (File file : files) {
            if (ImportUtils.isFileSupported(file)) continue;
            isUnsupported = true;
        }
        return isUnsupported;
    }

    public static boolean isFileSupported(File file) {
        return application.getDataManager().guessContentType(file).isSupported();
    }

    public static String convertToDatasetName(String fileName) {
        return fileName;
    }

    public static String getExtension(String fileName) {
        if (fileName.contains(".")) {
            return fileName.substring(fileName.indexOf(46), fileName.length());
        }
        return "";
    }

    public static String URLToFilename(URL url) {
        String fileName = url.getFile().substring(url.getFile().lastIndexOf("/") + 1, url.getFile().length());
        if (ImportUtils.convertToDatasetName(fileName).length() < 3) {
            fileName = "url_" + fileName;
        }
        return fileName;
    }

    public static void executeImport(ImportSession importSession) {
        List<File> files = importSession.getInputFiles();
        if (importSession.isSkipActionChooser() && !ImportUtils.containsUnsupportedTypes(files.toArray(new File[files.size()]))) {
            application.importGroup(importSession.getImportItems(), importSession.getDestinationFolder());
        } else {
            ActionChooserScreen actionChooser = new ActionChooserScreen(importSession);
            actionChooser.getFrame().setVisible(true);
        }
    }

    public static void main(String[] args) throws IOException, ConfigurationLoader.OldConfigurationFormatException, MicroarrayException {
        MicroarrayConfiguration.loadConfiguration();
        DialogInfo info = new DialogInfo(DialogInfo.Severity.INFO, "ZIP files detected", "There seems to be ZIP files on your desktop. This can slow down selecting files in some Windows versions. If you experience this problem, please move the ZIP files to a subfolder.", null, DialogInfo.Type.OK_MESSAGE);
        ChipsterDialog.showDialog(null, info, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, true, null);
    }

    public static class FileLoaderProcess
    extends RunnableImportProcess {
        private File outputFile;
        private URL url;
        private InformationDialog info;
        private String importFolder;
        private boolean skipActionChooser;

        public FileLoaderProcess(File outputFile, URL url, String importFolder, InformationDialog info, boolean skipActionChooser) {
            super(info);
            this.outputFile = outputFile;
            this.url = url;
            this.info = info;
            this.importFolder = importFolder;
            this.skipActionChooser = skipActionChooser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void taskToDo() {
            HttpURLConnection connection;
            block10: {
                connection = null;
                try {
                    int numRead;
                    connection = (HttpURLConnection)this.url.openConnection();
                    this.info.setMinimunValue(0);
                    this.info.setMaximumValue(connection.getContentLength());
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                    InputStream in = connection.getInputStream();
                    byte[] buffer = new byte[1024];
                    int numWritten = 0;
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                        this.info.setValue(numWritten += numRead);
                    }
                    out.close();
                    if (numWritten > 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ImportUtils.executeImport(new ImportSession(ImportSession.Source.URL, new File[]{FileLoaderProcess.this.outputFile}, FileLoaderProcess.this.importFolder, FileLoaderProcess.this.skipActionChooser));
                            }
                        });
                        break block10;
                    }
                    JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "Length of the loaded file is zero, import aborted", "File size too small", 0);
                }
                catch (IOException e) {
                    block11: {
                        if (e instanceof FileNotFoundException) {
                            JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "File from the typed url can't be found", "File not found", 0);
                            break block11;
                        }
                        if (e instanceof UnknownHostException) {
                            JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "Host from the typed url can't be found", "Host not found", 0);
                            break block11;
                        }
                        application.reportException(e);
                    }
                    IOUtils.disconnectIfPossible(connection);
                }
                catch (IllegalArgumentException e2) {
                    JOptionPane.showMessageDialog(((SwingClientApplication)application).getMainFrame(), "Malformed URL, correct URL form is http://www.host.com/file.ext", "Malformed URL", 0);
                    {
                        catch (Throwable throwable) {
                            IOUtils.disconnectIfPossible(connection);
                            throw throwable;
                        }
                    }
                    IOUtils.disconnectIfPossible(connection);
                }
            }
            IOUtils.disconnectIfPossible(connection);
        }
    }

    public static class URLFileLoader {
        public File loadFileFromURL(URL url, File outputFile, String importFolder, boolean skipActionChooser) {
            logger.debug((Object)"Method loadFileFromURL started");
            InformationDialog info = new InformationDialog("Loading file", "Loading file from the specified URL", null);
            logger.debug((Object)"Next the download process will start");
            new FileLoaderProcess(outputFile, url, importFolder, info, skipActionChooser).runProcess();
            logger.debug((Object)"Download process started");
            return outputFile;
        }
    }
}

