/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.auth.LoginModuleBase;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.LookaheadStringReader;
import fi.csc.microarray.util.config.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.log4j.Logger;
import org.mortbay.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileLoginModule
extends LoginModuleBase {
    public static final DateFormat EXPIRATION_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DELIMETER_CHARACTER = ":";
    public static final String COMMENT_CHARACTER = "#";
    private static final Logger logger = Logger.getLogger(SimpleFileLoginModule.class);
    private static final String DEFAULT_PASSWD_FILE = "/users.default";
    protected File passwdFile;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String passwdFileName = (String)options.get("passwdFile");
        if (passwdFileName == null || passwdFileName.equals("")) {
            this.createDefaultPasswdFile();
            return;
        }
        this.passwdFile = new File(passwdFileName);
        if (this.passwdFile.isAbsolute()) {
            if (!this.passwdFile.exists()) {
                logger.warn((Object)("Passwd file " + this.passwdFile.getPath() + " not found."));
            }
        } else {
            this.passwdFile = new File(MicroarrayConfiguration.getWorkDir(), this.passwdFile.getName());
            if (!this.passwdFile.exists()) {
                logger.warn((Object)("Passwd file " + this.passwdFile.getPath() + " not found."));
                this.createDefaultPasswdFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean authenticate(String username, char[] password) throws IOException {
        logger.debug((Object)(this.getClass().getName() + " authenticating " + username));
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.passwdFile));
            String line = reader.readLine();
            while (line != null) {
                String readUsername;
                LookaheadStringReader tokens;
                if (line.trim().length() != 0 && !(tokens = new LookaheadStringReader(line)).lookahead().equals(COMMENT_CHARACTER) && (readUsername = tokens.readTo(DELIMETER_CHARACTER)).equals(username)) {
                    tokens.read();
                    StringBuffer readPassword = tokens.readToSB(DELIMETER_CHARACTER);
                    boolean match = true;
                    for (int i = 0; i < readPassword.length(); ++i) {
                        if (readPassword.length() != password.length || readPassword.charAt(i) != password[i]) {
                            match = false;
                        }
                        readPassword.setCharAt(i, '\u0000');
                    }
                    if (match) {
                        if (!tokens.isAtEnd() && tokens.lookahead().equals(DELIMETER_CHARACTER)) {
                            tokens.read();
                            String expiration = tokens.readTo(DELIMETER_CHARACTER);
                            if (expiration.trim().length() > 0) {
                                try {
                                    Date expirationDate = EXPIRATION_DATE_FORMAT.parse(expiration);
                                    if (new Date().after(expirationDate)) {
                                        match = false;
                                    }
                                }
                                catch (ParseException e) {
                                    logger.error((Object)("when authenticating " + username + " failed to parse exp. date: " + expiration));
                                    match = false;
                                }
                            }
                        }
                        if (match) {
                            boolean bl = true;
                            IOUtils.closeIfPossible(reader);
                            return bl;
                        }
                    }
                }
                line = reader.readLine();
            }
            IOUtils.closeIfPossible(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIfPossible(reader);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultPasswdFile() {
        try {
            File defaultFile = new File(MicroarrayConfiguration.getWorkDir(), "users");
            if (defaultFile.exists()) {
                return;
            }
            logger.info((Object)("Creating new default passwd file " + defaultFile.getPath()));
            InputStream defaults = Configuration.class.getResourceAsStream(DEFAULT_PASSWD_FILE);
            FileOutputStream out = new FileOutputStream(defaultFile);
            try {
                IO.copy((InputStream)defaults, (OutputStream)out);
            }
            finally {
                if (defaults != null) {
                    defaults.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Could not create default users file.", (Throwable)ioe);
        }
    }
}

