/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.auth.AuthenticationProvider;
import fi.csc.microarray.util.config.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.mortbay.util.IO;

public class JaasAuthenticationProvider
implements AuthenticationProvider {
    private static final String LOGIN_CONTEXT_NAME = "Chipster";
    private static final String DEFAULT_CONFIG_FILE = "/jaas.config.default";
    private static final String CONFIG_FILE = "jaas.config";
    private static final Logger logger = Logger.getLogger(JaasAuthenticationProvider.class);

    public JaasAuthenticationProvider() throws IOException {
        this.initialize();
    }

    public boolean authenticate(String username, char[] password) {
        LoginContext lc = null;
        try {
            lc = new LoginContext(LOGIN_CONTEXT_NAME, new SimpleCallbackHandler(username, password));
        }
        catch (LoginException le) {
            logger.error((Object)"Cannot create LoginContext. ", (Throwable)le);
            return false;
        }
        catch (SecurityException se) {
            logger.error((Object)"Cannot create LoginContext. ", (Throwable)se);
            return false;
        }
        try {
            lc.login();
            logger.info((Object)("Authentication successful for " + username));
        }
        catch (FailedLoginException fle) {
            logger.info((Object)("Authentication failed for " + username));
            return false;
        }
        catch (LoginException le) {
            logger.error((Object)("Could not perform authentication for " + username), (Throwable)le);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException {
        File jaasConfigFile = new File(MicroarrayConfiguration.getWorkDir() + File.separator + CONFIG_FILE);
        if (!jaasConfigFile.exists()) {
            logger.info((Object)("JAAS config file " + jaasConfigFile + " does not exist, creating default file."));
            InputStream defaults = Configuration.class.getResourceAsStream(DEFAULT_CONFIG_FILE);
            FileOutputStream out = new FileOutputStream(jaasConfigFile);
            try {
                IO.copy((InputStream)defaults, (OutputStream)out);
            }
            finally {
                if (defaults != null) {
                    defaults.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        System.setProperty("java.security.auth.login.config", jaasConfigFile.getPath());
    }

    private class SimpleCallbackHandler
    implements CallbackHandler {
        private String username;
        private char[] password;

        public SimpleCallbackHandler(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.username);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
}

