/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.activemq.store.jdbc.DatabaseLocker;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDatabaseLocker
implements DatabaseLocker {
    private static final Log LOG = LogFactory.getLog(DefaultDatabaseLocker.class);
    private final DataSource dataSource;
    private final Statements statements;
    private long sleepTime = 1000L;
    private Connection connection;
    private PreparedStatement statement;
    private boolean stopping;

    public DefaultDatabaseLocker(DataSource dataSource, Statements statements) {
        this.dataSource = dataSource;
        this.statements = statements;
    }

    public void start() throws Exception {
        this.stopping = false;
        LOG.info("Attempting to acquire the exclusive lock to become the Master broker");
        while (true) {
            try {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                String sql = this.statements.getLockCreateStatement();
                this.statement = this.connection.prepareStatement(sql);
                this.statement.execute();
            }
            catch (Exception e) {
                if (this.stopping) {
                    throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                }
                LOG.error("Failed to acquire lock: " + e, e);
                if (null != this.statement) {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException e1) {
                        LOG.warn("Caught while closing statement: " + e1, e1);
                    }
                    this.statement = null;
                }
                if (null != this.connection) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e1) {
                        LOG.warn("Caught while closing connection: " + e1, e1);
                    }
                    this.connection = null;
                }
                LOG.debug("Sleeping for " + this.sleepTime + " milli(s) before trying again to get the lock...");
                Thread.sleep(this.sleepTime);
                continue;
            }
            break;
        }
        LOG.info("Becoming the master on dataSource: " + this.dataSource);
    }

    public void stop() throws Exception {
        this.stopping = true;
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.close();
        }
    }

    public boolean keepAlive() {
        try {
            PreparedStatement statement = this.connection.prepareStatement(this.statements.getLockUpdateStatement());
            statement.setLong(1, System.currentTimeMillis());
            int rows = statement.executeUpdate();
            if (rows == 1) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to update database lock: " + e, e);
        }
        return false;
    }
}

