/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.broker.region.cursors.FilePendingMessageCursor;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.TopicStorePrefetch;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreDurableSubscriberCursor
extends AbstractPendingMessageCursor {
    private static final Log LOG = LogFactory.getLog(StoreDurableSubscriberCursor.class);
    private String clientId;
    private String subscriberName;
    private Map<Destination, TopicStorePrefetch> topics = new HashMap<Destination, TopicStorePrefetch>();
    private LinkedList<PendingMessageCursor> storePrefetches = new LinkedList();
    private boolean started;
    private PendingMessageCursor nonPersistent;
    private PendingMessageCursor currentCursor;
    private Subscription subscription;

    public StoreDurableSubscriberCursor(Broker broker, String clientId, String subscriberName, int maxBatchSize, Subscription subscription) {
        this.subscription = subscription;
        this.clientId = clientId;
        this.subscriberName = subscriberName;
        this.nonPersistent = broker.getBrokerService().isPersistent() ? new FilePendingMessageCursor(broker, clientId + subscriberName) : new VMPendingMessageCursor();
        this.nonPersistent.setMaxBatchSize(this.getMaxBatchSize());
        this.nonPersistent.setSystemUsage(this.systemUsage);
        this.nonPersistent.setEnableAudit(this.isEnableAudit());
        this.nonPersistent.setMaxAuditDepth(this.getMaxAuditDepth());
        this.nonPersistent.setMaxProducersToAudit(this.getMaxProducersToAudit());
        this.storePrefetches.add(this.nonPersistent);
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            this.started = true;
            super.start();
            for (PendingMessageCursor tsp : this.storePrefetches) {
                tsp.setMessageAudit(this.getMessageAudit());
                tsp.start();
            }
        }
    }

    public synchronized void stop() throws Exception {
        if (this.started) {
            this.started = false;
            super.stop();
            for (PendingMessageCursor tsp : this.storePrefetches) {
                tsp.stop();
            }
        }
    }

    public synchronized void add(ConnectionContext context, Destination destination) throws Exception {
        if (destination != null && !AdvisorySupport.isAdvisoryTopic(destination.getActiveMQDestination())) {
            TopicStorePrefetch tsp = new TopicStorePrefetch(this.subscription, (Topic)destination, this.clientId, this.subscriberName);
            tsp.setMaxBatchSize(this.getMaxBatchSize());
            tsp.setSystemUsage(this.systemUsage);
            tsp.setEnableAudit(this.isEnableAudit());
            tsp.setMaxAuditDepth(this.getMaxAuditDepth());
            tsp.setMaxProducersToAudit(this.getMaxProducersToAudit());
            this.topics.put(destination, tsp);
            this.storePrefetches.add(tsp);
            if (this.started) {
                tsp.start();
            }
        }
    }

    public synchronized void remove(ConnectionContext context, Destination destination) throws Exception {
        TopicStorePrefetch tsp = this.topics.remove(destination);
        if (tsp != null) {
            this.storePrefetches.remove(tsp);
        }
    }

    public synchronized boolean isEmpty() {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            if (tsp.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isEmpty(Destination destination) {
        boolean result = true;
        TopicStorePrefetch tsp = this.topics.get(destination);
        if (tsp != null) {
            result = tsp.isEmpty();
        }
        return result;
    }

    public boolean isRecoveryRequired() {
        return false;
    }

    public synchronized void addMessageLast(MessageReference node) throws Exception {
        if (node != null) {
            Destination dest;
            TopicStorePrefetch tsp;
            Message msg = node.getMessage();
            if (this.started && !msg.isPersistent()) {
                this.nonPersistent.addMessageLast(node);
            }
            if (msg.isPersistent() && (tsp = this.topics.get(dest = msg.getRegionDestination())) != null) {
                tsp.addMessageLast(node);
            }
        }
    }

    public synchronized void addRecoveredMessage(MessageReference node) throws Exception {
        this.nonPersistent.addMessageLast(node);
    }

    public synchronized void clear() {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            tsp.clear();
        }
    }

    public synchronized boolean hasNext() {
        boolean result = true;
        if (result) {
            try {
                this.currentCursor = this.getNextCursor();
            }
            catch (Exception e) {
                LOG.error("Failed to get current cursor ", e);
                throw new RuntimeException(e);
            }
            result = this.currentCursor != null ? this.currentCursor.hasNext() : false;
        }
        return result;
    }

    public synchronized MessageReference next() {
        MessageReference result = this.currentCursor != null ? this.currentCursor.next() : null;
        return result;
    }

    public synchronized void remove() {
        if (this.currentCursor != null) {
            this.currentCursor.remove();
        }
    }

    public synchronized void remove(MessageReference node) {
        if (this.currentCursor != null) {
            this.currentCursor.remove(node);
        }
    }

    public synchronized void reset() {
        for (AbstractPendingMessageCursor abstractPendingMessageCursor : this.storePrefetches) {
            abstractPendingMessageCursor.reset();
        }
    }

    public synchronized void release() {
        for (AbstractPendingMessageCursor abstractPendingMessageCursor : this.storePrefetches) {
            abstractPendingMessageCursor.release();
        }
    }

    public synchronized int size() {
        int pendingCount = 0;
        for (PendingMessageCursor tsp : this.storePrefetches) {
            pendingCount += tsp.size();
        }
        return pendingCount;
    }

    public synchronized void setMaxBatchSize(int maxBatchSize) {
        for (AbstractPendingMessageCursor abstractPendingMessageCursor : this.storePrefetches) {
            abstractPendingMessageCursor.setMaxBatchSize(maxBatchSize);
        }
        super.setMaxBatchSize(maxBatchSize);
    }

    public synchronized void gc() {
        for (PendingMessageCursor tsp : this.storePrefetches) {
            tsp.gc();
        }
    }

    public synchronized void setSystemUsage(SystemUsage usageManager) {
        super.setSystemUsage(usageManager);
        for (PendingMessageCursor tsp : this.storePrefetches) {
            tsp.setSystemUsage(usageManager);
        }
    }

    public synchronized void setMaxProducersToAudit(int maxProducersToAudit) {
        super.setMaxProducersToAudit(maxProducersToAudit);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setMaxAuditDepth(this.maxAuditDepth);
        }
    }

    public synchronized void setMaxAuditDepth(int maxAuditDepth) {
        super.setMaxAuditDepth(maxAuditDepth);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setMaxAuditDepth(maxAuditDepth);
        }
    }

    public synchronized void setEnableAudit(boolean enableAudit) {
        super.setEnableAudit(enableAudit);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setEnableAudit(enableAudit);
        }
    }

    public synchronized void setUseCache(boolean useCache) {
        super.setUseCache(useCache);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.setUseCache(useCache);
        }
    }

    public synchronized void dispatched(MessageReference message) {
        super.dispatched(message);
        for (PendingMessageCursor cursor : this.storePrefetches) {
            cursor.dispatched(message);
        }
    }

    protected synchronized PendingMessageCursor getNextCursor() throws Exception {
        if (this.currentCursor == null || this.currentCursor.isEmpty()) {
            this.currentCursor = null;
            for (AbstractPendingMessageCursor abstractPendingMessageCursor : this.storePrefetches) {
                if (!abstractPendingMessageCursor.hasNext()) continue;
                this.currentCursor = abstractPendingMessageCursor;
                break;
            }
            this.storePrefetches.addLast(this.storePrefetches.removeFirst());
        }
        return this.currentCursor;
    }

    public String toString() {
        return "StoreDurableSubscriber(" + this.clientId + ":" + this.subscriberName + ")";
    }
}

