/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.OverridingClassLoader;
import org.springframework.core.SmartClassLoader;
import org.springframework.util.ReflectionUtils;

class ContextTypeMatchClassLoader
extends ClassLoader
implements SmartClassLoader {
    private static Method findLoadedClassMethod;
    private final Map bytesCache = new HashMap();

    public ContextTypeMatchClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return new ContextOverridingClassLoader(this.getParent()).loadClass(name);
    }

    public boolean isClassReloadable(Class clazz) {
        return clazz.getClassLoader() instanceof ContextOverridingClassLoader;
    }

    static {
        try {
            findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        }
        catch (NoSuchMethodException ex) {
            findLoadedClassMethod = null;
        }
    }

    private class ContextOverridingClassLoader
    extends OverridingClassLoader {
        public ContextOverridingClassLoader(ClassLoader parent) {
            super(parent);
        }

        protected boolean isEligibleForOverriding(String className) {
            if (!super.isEligibleForOverriding(className)) {
                return false;
            }
            if (findLoadedClassMethod != null) {
                ReflectionUtils.makeAccessible((Method)findLoadedClassMethod);
                if (ReflectionUtils.invokeMethod((Method)findLoadedClassMethod, (Object)this.getParent(), (Object[])new Object[]{className}) != null) {
                    return false;
                }
            }
            return true;
        }

        protected Class loadClassForOverriding(String name) throws ClassNotFoundException {
            byte[] bytes = (byte[])ContextTypeMatchClassLoader.this.bytesCache.get(name);
            if (bytes == null) {
                bytes = this.loadBytesForClass(name);
                if (bytes != null) {
                    ContextTypeMatchClassLoader.this.bytesCache.put(name, bytes);
                } else {
                    return null;
                }
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

