/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.SOMItemEntity;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.SOMToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.som.SOMDataItem;
import org.jfree.data.som.SOMDataset;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextMeasurer;
import org.jfree.text.TextUtilities;
import org.jfree.util.ObjectUtilities;

public class SOMPlot
extends Plot
implements ChartMouseListener,
ChangeListener,
Cloneable,
Serializable {
    private SOMDataset dataset;
    private SOMToolTipGenerator toolTipGenerator;
    private int colorHueAdjustment;
    private List selectedCells;
    private JSlider colorHueSlider;
    private JSlider distanceSlider;
    private Font descriptionFont;
    private static final Font DEFAULT_DESCRIPTION_FONT = new Font("SansSerif", 0, 8);
    private static final float DESCRIPTION_WIDTH_RATIO = 0.9f;
    private static final int HORIZONTAL_GAP = 3;
    private static final int VERTICAL_GAP = 3;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public SOMPlot(SOMDataset dataset) throws NullPointerException {
        if (DatasetUtilities.isEmptyOrNull(dataset)) {
            throw new NullPointerException("Dataset given to SOMPlot was null or empty.");
        }
        this.dataset = dataset;
        this.toolTipGenerator = null;
        this.colorHueAdjustment = 0;
        this.selectedCells = new LinkedList();
        this.distanceSlider = new JSlider(0, 444, 0);
        this.colorHueSlider = new JSlider(0, 359, this.colorHueAdjustment);
        this.descriptionFont = DEFAULT_DESCRIPTION_FONT;
    }

    public SOMDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(SOMDataset dataset) throws NullPointerException {
        if (dataset == null) {
            throw new NullPointerException("Dataset given to SOMPlot was null");
        }
        this.dataset = dataset;
    }

    public SOMToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(SOMToolTipGenerator toolTipGenerator) {
        this.toolTipGenerator = toolTipGenerator;
    }

    public String getPlotType() {
        return localizationResources.getString("SOM_Plot");
    }

    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    public void setDescriptionFont(Font descriptionFont) throws NullPointerException {
        if (descriptionFont == null) {
            throw new NullPointerException("Description font given to SOMPlot was null");
        }
        this.descriptionFont = descriptionFont;
    }

    public JSlider getColorHueSlider() {
        return this.colorHueSlider;
    }

    public JSlider getDistanceSlider() {
        return this.distanceSlider;
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        this.getInsets().trim(area);
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        this.drawBackground(g2, area);
        this.drawOutline(g2, area);
        Shape savedClip = g2.getClip();
        g2.clip(area);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.drawSOM(g2, area, info);
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, area);
    }

    private void drawSOM(Graphics2D g2, Rectangle2D area, PlotRenderingInfo info) {
        double edgeLengthByWidth = (area.getWidth() - (double)(this.dataset.getColumnCount() * (3 + 1))) / ((double)(1 + 2 * this.dataset.getColumnCount()) * Math.cos(0.5235987755982988));
        double edgeLengthByHeight = (area.getHeight() - (double)(this.dataset.getRowCount() * (3 + 1))) / ((double)this.dataset.getRowCount() + (double)(this.dataset.getRowCount() + 1) * Math.sin(0.5235987755982988));
        double edgeLength = Math.min(edgeLengthByWidth, edgeLengthByHeight);
        Polygon hexagon = this.createHexagon(edgeLength);
        hexagon.translate((int)area.getMinX() + 1, (int)area.getMinY() + 1);
        int deltaX = hexagon.xpoints[1] - hexagon.xpoints[5] + 1 + 3;
        int deltaY = hexagon.ypoints[2] - hexagon.ypoints[0] + 1 + 3;
        for (int y = 0; y < this.dataset.getRowCount(); ++y) {
            for (int x = 0; x < this.dataset.getColumnCount(); ++x) {
                SOMDataItem item = this.dataset.getValue(x, y);
                if (item == null) continue;
                if (item.isSelected()) {
                    g2.setPaint(item.getColor());
                    g2.fillPolygon(hexagon);
                    g2.setPaint(this.contrastingColor(item.getColor()));
                    Stroke stroke = g2.getStroke();
                    g2.setStroke(new BasicStroke(1.5f));
                    g2.drawPolygon(hexagon);
                    g2.setStroke(stroke);
                } else {
                    g2.setPaint(item.getColor());
                    g2.fillPolygon(hexagon);
                }
                this.drawDescriptions(g2, hexagon, item);
                this.createEntity(x, y, new Polygon(hexagon.xpoints, hexagon.ypoints, hexagon.npoints), info);
                hexagon.translate(deltaX, 0);
            }
            if (y % 2 == 1) {
                hexagon.translate((int)(area.getMinX() - (double)hexagon.xpoints[5] + 1.0), deltaY);
                continue;
            }
            hexagon.translate((int)(area.getMinX() - (double)hexagon.xpoints[5] + 1.0), deltaY);
            hexagon.translate(hexagon.xpoints[0] - hexagon.xpoints[5] + ((3 >> 1) + 1), 0);
        }
    }

    private void drawDescriptions(Graphics2D g2, Polygon area, SOMDataItem item) {
        TextBlock block;
        Shape savedClip = g2.getClip();
        g2.clip(area);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < item.getDescriptions().length; ++i) {
            sb.append(item.getDescriptions()[i]);
            if (i >= item.getDescriptions().length - 1) continue;
            sb.append(" ");
        }
        String message = sb.toString();
        float maxWidth = area.xpoints[1] - area.xpoints[5];
        int maxLines = (area.ypoints[2] - area.ypoints[1]) / g2.getFontMetrics(this.descriptionFont).getHeight();
        maxLines = Math.max(maxLines, 1);
        if (message != null) {
            block = TextUtilities.createTextBlock((String)message, (Font)this.descriptionFont, (Paint)item.getColor(), (float)(0.9f * maxWidth), (int)maxLines, (TextMeasurer)new G2TextMeasurer(g2));
            block.draw(g2, (float)area.xpoints[5] + maxWidth / 2.0f, (float)area.ypoints[5], TextBlockAnchor.TOP_CENTER);
        }
        if (message != null) {
            block = TextUtilities.createTextBlock((String)message, (Font)this.descriptionFont, (Paint)this.contrastingColor(item.getColor()), (float)(0.9f * maxWidth), (int)maxLines, (TextMeasurer)new G2TextMeasurer(g2));
            block.draw(g2, (float)area.xpoints[5] + maxWidth / 2.0f, (float)area.ypoints[5], TextBlockAnchor.TOP_CENTER);
        }
        g2.setClip(savedClip);
    }

    private void createEntity(int x, int y, Shape shape, PlotRenderingInfo info) {
        EntityCollection entities;
        if (info != null && (entities = info.getOwner().getEntityCollection()) != null) {
            String tip = null;
            if (this.toolTipGenerator != null) {
                tip = this.toolTipGenerator.generateToolTip(this.dataset, x, y);
            }
            String url = null;
            entities.add(new SOMItemEntity(shape, this.dataset, x, y, tip, url));
        }
    }

    private Polygon createHexagon(double edgeLength) throws IllegalArgumentException {
        double sin30 = Math.sin(0.5235987755982988);
        double cos30 = Math.cos(0.5235987755982988);
        int[] xPoints = new int[6];
        int[] yPoints = new int[6];
        xPoints[0] = (int)(edgeLength * cos30);
        yPoints[0] = 0;
        xPoints[3] = xPoints[0];
        yPoints[3] = (int)(edgeLength + 2.0 * edgeLength * sin30);
        xPoints[1] = (int)(2.0 * edgeLength * cos30);
        yPoints[1] = (int)(edgeLength * sin30);
        xPoints[2] = xPoints[1];
        yPoints[2] = (int)((double)yPoints[1] + edgeLength);
        xPoints[4] = 0;
        yPoints[4] = yPoints[2];
        xPoints[5] = 0;
        yPoints[5] = yPoints[1];
        return new Polygon(xPoints, yPoints, 6);
    }

    private Color contrastingColor(Color color) {
        Color background = (Color)this.getBackgroundPaint();
        double distance = 0.0;
        Color returnValue = Color.BLACK;
        double tmp = this.colorDistance(Color.BLACK, background) + this.colorDistance(Color.BLACK, color);
        if (tmp > distance) {
            distance = tmp;
            returnValue = Color.BLACK;
        }
        if ((tmp = this.colorDistance(Color.WHITE, background) + this.colorDistance(Color.WHITE, color)) > distance) {
            distance = tmp;
            returnValue = Color.WHITE;
        }
        if ((tmp = this.colorDistance(Color.RED, background) + this.colorDistance(Color.RED, color)) > distance) {
            distance = tmp;
            returnValue = Color.RED;
        }
        if ((tmp = this.colorDistance(Color.GREEN, background) + this.colorDistance(Color.GREEN, color)) > distance) {
            distance = tmp;
            returnValue = Color.GREEN;
        }
        if ((tmp = this.colorDistance(Color.BLUE, background) + this.colorDistance(Color.BLUE, color)) > distance) {
            distance = tmp;
            returnValue = Color.BLUE;
        }
        return returnValue;
    }

    private double colorDistance(Color color1, Color color2) {
        int r1 = color1.getRed();
        int g1 = color1.getGreen();
        int b1 = color1.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        return Math.sqrt((r1 - r2) * (r1 - r2) + (g1 - g2) * (g1 - g2) + (b1 - b2) * (b1 - b2));
    }

    public JPanel getPanel() {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.LocalizationBundle");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.colorHueSlider.setPaintLabels(true);
        this.colorHueSlider.setPaintTicks(true);
        this.colorHueSlider.setMajorTickSpacing(90);
        this.colorHueSlider.setMinorTickSpacing(30);
        this.colorHueSlider.setPaintTrack(false);
        this.colorHueSlider.addChangeListener(this);
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)new JLabel(lr.getString("Adjust_colors")), c);
        c.gridx = 1;
        c.gridy = 0;
        panel.add((Component)this.colorHueSlider, c);
        this.distanceSlider.setPaintLabels(true);
        this.distanceSlider.setPaintTicks(true);
        this.distanceSlider.setMajorTickSpacing(100);
        this.distanceSlider.setMinorTickSpacing(25);
        this.distanceSlider.setPaintTrack(false);
        this.distanceSlider.addChangeListener(this);
        if (this.selectedCells.size() == 1) {
            this.distanceSlider.setEnabled(true);
        } else {
            this.distanceSlider.setEnabled(false);
        }
        c.insets = new Insets(30, 0, 0, 0);
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)new JLabel(lr.getString("Select_neighbors")), c);
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 1;
        panel.add((Component)this.distanceSlider, c);
        return panel;
    }

    public String getPanelName() {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.LocalizationBundle");
        return lr.getString("SOM_panel");
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof SOMItemEntity) {
            SOMItemEntity entity = (SOMItemEntity)event.getEntity();
            SOMDataItem item = entity.getDataset().getValue(entity.getX(), entity.getY());
            if (event.getTrigger().isControlDown()) {
                this.handleCtrlClick(item);
            } else if (event.getTrigger().isShiftDown()) {
                this.handleShiftClick(item);
            } else {
                this.handleClick(item);
            }
        }
    }

    private void handleCtrlClick(SOMDataItem item) {
        if (item.isSelected()) {
            this.selectedCells.remove(item);
            item.setSelected(false);
        } else {
            this.selectedCells.add(item);
            item.setSelected(true);
        }
    }

    private void handleShiftClick(SOMDataItem cornerItem1) {
        SOMDataItem cornerItem2 = !this.selectedCells.isEmpty() ? (SOMDataItem)this.selectedCells.get(0) : this.dataset.getValue(0, 0);
        List areaCells = this.dataset.getArea(cornerItem1, cornerItem2);
        areaCells.remove(cornerItem2);
        areaCells.add(0, cornerItem2);
        this.dataset.deselectAll();
        this.selectedCells = areaCells;
        Iterator i = areaCells.iterator();
        while (i.hasNext()) {
            SOMDataItem item = (SOMDataItem)i.next();
            item.setSelected(true);
        }
    }

    private void handleClick(SOMDataItem item) {
        if (item.isSelected()) {
            this.selectedCells.clear();
            this.dataset.deselectAll();
        } else {
            this.selectedCells.clear();
            this.dataset.deselectAll();
            this.selectedCells.add(item);
            item.setSelected(true);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.colorHueSlider) {
            int value = this.colorHueSlider.getValue();
            this.dataset.changeHueValues(this.colorHueAdjustment - value);
            this.colorHueAdjustment = value;
        } else if (e.getSource() == this.distanceSlider) {
            int value = this.distanceSlider.getValue();
            SOMDataItem center = (SOMDataItem)this.selectedCells.get(0);
            List l = this.dataset.getNeighbors(center, value, false);
            this.dataset.deselectAll();
            this.selectedCells.clear();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                SOMDataItem item = (SOMDataItem)i.next();
                item.setSelected(true);
                this.selectedCells.add(item);
            }
            center.setSelected(true);
            this.selectedCells.add(0, center);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SOMPlot)) {
            return false;
        }
        SOMPlot that = (SOMPlot)obj;
        if (!ObjectUtilities.equal((Object)this.toolTipGenerator, (Object)that.toolTipGenerator)) {
            return false;
        }
        if (this.colorHueAdjustment != that.colorHueAdjustment) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.descriptionFont, (Object)that.descriptionFont);
    }

    public Object clone() throws CloneNotSupportedException {
        SOMPlot clone = (SOMPlot)super.clone();
        if (clone.dataset != null) {
            clone.dataset.addChangeListener(clone);
        }
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

