/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.ParsingFeedException;
import com.sun.syndication.io.WireFeedParser;
import com.sun.syndication.io.impl.FeedParsers;
import com.sun.syndication.io.impl.XmlFixerReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class WireFeedInput {
    private static FeedParsers FEED_PARSERS = new FeedParsers();
    private static final InputSource EMPTY_INPUTSOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));
    private static final EntityResolver RESOLVER = new EmptyEntityResolver();
    private boolean _validate = false;
    private boolean _xmlHealerOn = true;

    public static List getSupportedFeedTypes() {
        return FEED_PARSERS.getSupportedFeedTypes();
    }

    public WireFeedInput() {
        this(false);
    }

    public WireFeedInput(boolean validate) {
    }

    public void setXmlHealerOn(boolean heals) {
        this._xmlHealerOn = heals;
    }

    public boolean getXmlHealerOn() {
        return this._xmlHealerOn;
    }

    public WireFeed build(File file) throws FileNotFoundException, IOException, IllegalArgumentException, FeedException {
        Reader reader = new FileReader(file);
        if (this._xmlHealerOn) {
            reader = new XmlFixerReader(reader);
        }
        WireFeed feed = this.build(reader);
        reader.close();
        return feed;
    }

    public WireFeed build(Reader reader) throws IllegalArgumentException, FeedException {
        SAXBuilder saxBuilder = new SAXBuilder(this._validate);
        saxBuilder.setEntityResolver(RESOLVER);
        try {
            if (this._xmlHealerOn) {
                reader = new XmlFixerReader(reader);
            }
            Document document = saxBuilder.build(reader);
            return this.build(document);
        }
        catch (JDOMParseException ex) {
            throw new ParsingFeedException("Invalid XML: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new ParsingFeedException("Invalid XML", ex);
        }
    }

    public WireFeed build(InputSource is) throws IllegalArgumentException, FeedException {
        SAXBuilder saxBuilder = new SAXBuilder(this._validate);
        saxBuilder.setEntityResolver(RESOLVER);
        try {
            Document document = saxBuilder.build(is);
            return this.build(document);
        }
        catch (JDOMParseException ex) {
            throw new ParsingFeedException("Invalid XML: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new ParsingFeedException("Invalid XML", ex);
        }
    }

    public WireFeed build(org.w3c.dom.Document document) throws IllegalArgumentException, FeedException {
        DOMBuilder domBuilder = new DOMBuilder();
        try {
            Document jdomDoc = domBuilder.build(document);
            return this.build(jdomDoc);
        }
        catch (Exception ex) {
            throw new ParsingFeedException("Invalid XML", ex);
        }
    }

    public WireFeed build(Document document) throws IllegalArgumentException, FeedException {
        WireFeedParser parser = FEED_PARSERS.getParserFor(document);
        if (parser == null) {
            throw new IllegalArgumentException("Invalid document");
        }
        return parser.parse(document, this._validate);
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        private EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId != null && systemId.endsWith(".dtd")) {
                return EMPTY_INPUTSOURCE;
            }
            return null;
        }
    }
}

