/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Configuration;
import org.testng.annotations.DataProvider;
import org.testng.annotations.ExpectedExceptions;
import org.testng.annotations.Factory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.IDataProvider;
import org.testng.internal.annotations.IExpectedExceptions;
import org.testng.internal.annotations.IFactory;
import org.testng.internal.annotations.IObjectFactory;
import org.testng.internal.annotations.IParameters;
import org.testng.internal.annotations.ITest;
import org.testng.internal.annotations.JDK15TagFactory;

public class JDK15AnnotationFinder
implements IAnnotationFinder {
    private JDK15TagFactory m_tagFactory = new JDK15TagFactory();
    private Map<Class<?>, Class<?>> m_annotationMap = new HashMap();
    private IAnnotationTransformer m_transformer = null;

    public JDK15AnnotationFinder(IAnnotationTransformer transformer) {
        this.m_transformer = transformer;
        this.m_annotationMap.put(IConfiguration.class, Configuration.class);
        this.m_annotationMap.put(IDataProvider.class, DataProvider.class);
        this.m_annotationMap.put(IExpectedExceptions.class, ExpectedExceptions.class);
        this.m_annotationMap.put(IFactory.class, Factory.class);
        this.m_annotationMap.put(IObjectFactory.class, ObjectFactory.class);
        this.m_annotationMap.put(IParameters.class, Parameters.class);
        this.m_annotationMap.put(ITest.class, Test.class);
        this.m_annotationMap.put(IBeforeSuite.class, BeforeSuite.class);
        this.m_annotationMap.put(IAfterSuite.class, AfterSuite.class);
        this.m_annotationMap.put(IBeforeTest.class, BeforeTest.class);
        this.m_annotationMap.put(IAfterTest.class, AfterTest.class);
        this.m_annotationMap.put(IBeforeClass.class, BeforeClass.class);
        this.m_annotationMap.put(IAfterClass.class, AfterClass.class);
        this.m_annotationMap.put(IBeforeGroups.class, BeforeGroups.class);
        this.m_annotationMap.put(IAfterGroups.class, AfterGroups.class);
        this.m_annotationMap.put(IBeforeMethod.class, BeforeMethod.class);
        this.m_annotationMap.put(IAfterMethod.class, AfterMethod.class);
    }

    private Annotation findAnnotationInSuperClasses(Class cls, Class a) {
        while (cls != null) {
            Object result = cls.getAnnotation(a);
            if (result != null) {
                return result;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public IAnnotation findAnnotation(Method m, Class annotationClass) {
        Class<?> a = this.m_annotationMap.get(annotationClass);
        assert (a != null) : "Annotation class not found:" + annotationClass;
        IAnnotation result = this.findAnnotation(m.getDeclaringClass(), (Annotation)m.getAnnotation(a), annotationClass);
        this.transform(result, null, null, m);
        return result;
    }

    private void transform(IAnnotation a, Class testClass, Constructor testConstructor, Method testMethod) {
        if (a instanceof ITest) {
            this.m_transformer.transform((ITest)a, testClass, testConstructor, testMethod);
        }
    }

    public IAnnotation findAnnotation(Class cls, Class annotationClass) {
        Class<?> a = this.m_annotationMap.get(annotationClass);
        IAnnotation result = this.findAnnotation(cls, this.findAnnotationInSuperClasses(cls, a), annotationClass);
        this.transform(result, cls, null, null);
        return result;
    }

    public IAnnotation findAnnotation(Constructor m, Class annotationClass) {
        Class<?> a = this.m_annotationMap.get(annotationClass);
        IAnnotation result = this.findAnnotation(m.getDeclaringClass(), (Annotation)m.getAnnotation(a), annotationClass);
        this.transform(result, null, m, null);
        return result;
    }

    private IAnnotation findAnnotation(Class cls, Annotation a, Class annotationClass) {
        IAnnotation result = this.m_tagFactory.createTag(cls, a, annotationClass, this.m_transformer);
        return result;
    }

    private void ppp(String string) {
        System.out.println("[JDK15AnnotationFinder] " + string);
    }

    public void addSourceDirs(String[] dirs) {
    }
}

