/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.SessionScope;

public abstract class WebApplicationContextUtils {
    public static WebApplicationContext getWebApplicationContext(ServletContext sc) {
        Assert.notNull((Object)sc, (String)"ServletContext must not be null");
        Object attr = sc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (!(attr instanceof WebApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + attr);
        }
        return (WebApplicationContext)attr;
    }

    public static WebApplicationContext getRequiredWebApplicationContext(ServletContext sc) throws IllegalStateException {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(sc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    static void registerWebApplicationScopes(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope("request", (Scope)new RequestScope());
        beanFactory.registerScope("session", (Scope)new SessionScope(false));
        beanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        beanFactory.registerResolvableDependency(ServletRequest.class, (Object)new ObjectFactory(){

            public Object getObject() {
                RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
                if (!(requestAttr instanceof ServletRequestAttributes)) {
                    throw new IllegalStateException("Current request is not a servlet request");
                }
                return ((ServletRequestAttributes)requestAttr).getRequest();
            }
        });
        beanFactory.registerResolvableDependency(HttpSession.class, (Object)new ObjectFactory(){

            public Object getObject() {
                RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
                if (!(requestAttr instanceof ServletRequestAttributes)) {
                    throw new IllegalStateException("Current request is not a servlet request");
                }
                return ((ServletRequestAttributes)requestAttr).getRequest().getSession();
            }
        });
    }
}

