/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;

public class TestResult
implements ITestResult {
    private IClass m_testClass = null;
    private ITestNGMethod m_method = null;
    private int m_status = -1;
    private Throwable m_throwable = null;
    private long m_startMillis = 0L;
    private long m_endMillis = 0L;
    private String m_name = null;
    private String m_host;
    private Object[] m_parameters = new Object[0];

    public TestResult(IClass testClass, Object instance, ITestNGMethod method, Throwable throwable, long start, long end) {
        this.m_testClass = testClass;
        this.m_throwable = throwable;
        if (null == this.m_throwable) {
            this.m_status = 1;
        }
        this.m_startMillis = start;
        this.m_endMillis = end;
        this.m_method = method;
        this.m_name = this.m_method.getMethod().getName();
        if (null != instance && instance instanceof ITest) {
            this.m_name = this.m_name + " (" + ((ITest)instance).getTestName() + ")";
        }
    }

    private static void ppp(String s) {
        System.out.println("[TestResult] " + s);
    }

    public void setEndMillis(long millis) {
        this.m_endMillis = millis;
    }

    public String getName() {
        return this.m_name;
    }

    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public void setMethod(ITestNGMethod method) {
        this.m_method = method;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    public boolean isSuccess() {
        return 1 == this.m_status;
    }

    public IClass getTestClass() {
        return this.m_testClass;
    }

    public void setTestClass(IClass testClass) {
        this.m_testClass = testClass;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    public long getEndMillis() {
        return this.m_endMillis;
    }

    public long getStartMillis() {
        return this.m_startMillis;
    }

    public String toString() {
        List<String> output = Reporter.getOutput(this);
        String result = "[TestResult: " + this.getName() + " STATUS:" + this.m_status + " METHOD:" + this.m_method;
        result = result + (output != null && output.size() > 0 ? output.get(0) : "]");
        return result;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public Object[] getParameters() {
        return this.m_parameters;
    }

    public void setParameters(Object[] parameters) {
        this.m_parameters = parameters;
    }
}

