/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Assert;
import org.fest.assertions.Fail;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectAssert
extends Assert<Object> {
    ObjectAssert(Object actual) {
        super(actual);
    }

    public ObjectAssert isInstanceOf(Class<?> type) {
        this.isNotNull();
        Class<?> current = this.actual.getClass();
        if (!type.isAssignableFrom(current)) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expected instance of:<", type.getName(), "> but was instance of:<", current.getName(), ">"}));
        }
        return this;
    }

    public ObjectAssert isInstanceOfAny(Class<?> ... types) {
        this.isNotNull();
        Class<?> current = this.actual.getClass();
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(current)) continue;
            return this;
        }
        Fail.fail(Strings.concat((Object[])new Object[]{"expected instance of any:<", Arrays.toString(Objects.namesOf((Class[])types)), "> but was instance of:<", current.getName(), ">"}));
        return this;
    }

    public ObjectAssert isNotNull() {
        return (ObjectAssert)super.isNotNull();
    }

    public ObjectAssert isSameAs(Object expected) {
        return (ObjectAssert)super.isSameAs(expected);
    }

    public ObjectAssert isNotSameAs(Object other) {
        return (ObjectAssert)super.isNotSameAs(other);
    }

    public ObjectAssert isEqualTo(Object expected) {
        return (ObjectAssert)super.isEqualTo(expected);
    }

    public ObjectAssert isNotEqualTo(Object other) {
        return (ObjectAssert)super.isNotEqualTo(other);
    }
}

