/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveFail;

public class FloatAssert {
    private static final float ZERO = 0.0f;
    private final float actual;

    FloatAssert(float actual) {
        this.actual = actual;
    }

    public FloatAssert isEqualTo(float expected) {
        PrimitiveFail.failIfNotEqual(this.actual, expected);
        return this;
    }

    public FloatAssert isNotEqualTo(float other) {
        PrimitiveFail.failIfEqual(this.actual, other);
        return this;
    }

    public FloatAssert isZero() {
        return this.isEqualTo(0.0f);
    }

    public FloatAssert isGreaterThan(float smaller) {
        PrimitiveFail.failIfNotGreaterThan(this.actual, smaller);
        return this;
    }

    public FloatAssert isLessThan(float bigger) {
        PrimitiveFail.failIfNotLessThan(this.actual, bigger);
        return this;
    }

    public FloatAssert isNaN() {
        return this.isEqualTo(Float.NaN);
    }

    public FloatAssert isPositive() {
        return this.isGreaterThan(0.0f);
    }

    public FloatAssert isNegative() {
        return this.isLessThan(0.0f);
    }
}

