/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.util.Objects;
import org.fest.util.Strings;

public final class Fail {
    public static void fail() {
        Fail.fail(null);
    }

    public static void fail(String message, Throwable realCause) {
        AssertionError error = new AssertionError((Object)message);
        ((Throwable)((Object)error)).initCause(realCause);
        throw error;
    }

    static void failIfEqual(Object first, Object second) {
        if (Objects.areEqual((Object)first, (Object)second)) {
            Fail.fail(Fail.errorMessageIfEqual(first, second));
        }
    }

    static void failIfNotEqual(Object actual, Object expected) {
        if (!Objects.areEqual((Object)actual, (Object)expected)) {
            Fail.fail(Fail.errorMessageIfNotEqual(actual, expected));
        }
    }

    static void failIfNull(Object o) {
        if (o == null) {
            Fail.fail(Strings.concat((Object[])new Object[]{"the given object, ", o, " should not be null"}));
        }
    }

    static void failIfNotNull(Object o) {
        if (o != null) {
            Fail.fail(Strings.concat((Object[])new Object[]{"<", o, "> should not be null"}));
        }
    }

    static void failIfSame(Object first, Object second) {
        if (first == second) {
            Fail.fail(Strings.concat((Object[])new Object[]{"same objects:<", first, ">"}));
        }
    }

    static void failIfNotSame(Object actual, Object expected) {
        if (actual != expected) {
            Fail.fail(Strings.concat((Object[])new Object[]{"expected same with:<", expected, "> but was:<", actual, ">"}));
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    static String errorMessageIfNotEqual(Object actual, Object expected) {
        return Strings.concat((Object[])new Object[]{"expected:<", expected, "> but was:<", actual, ">"});
    }

    static String errorMessageIfEqual(Object first, Object second) {
        return Strings.concat((Object[])new Object[]{"<", first, "> should not be equal to <", second, ">"});
    }

    private Fail() {
    }
}

