/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveFail;

public final class ByteAssert {
    private final byte actual;
    private static final byte ZERO = 0;

    ByteAssert(byte actual) {
        this.actual = actual;
    }

    public ByteAssert isEqualTo(byte expected) {
        PrimitiveFail.failIfNotEqual(this.actual, expected);
        return this;
    }

    public ByteAssert isNotEqualTo(byte other) {
        PrimitiveFail.failIfEqual(this.actual, other);
        return this;
    }

    public ByteAssert isGreaterThan(byte smaller) {
        PrimitiveFail.failIfNotGreaterThan(this.actual, smaller);
        return this;
    }

    public ByteAssert isLessThan(byte bigger) {
        PrimitiveFail.failIfNotLessThan(this.actual, bigger);
        return this;
    }

    public ByteAssert isPositive() {
        return this.isGreaterThan((byte)0);
    }

    public ByteAssert isNegative() {
        return this.isLessThan((byte)0);
    }

    public ByteAssert isZero() {
        return this.isEqualTo((byte)0);
    }
}

