/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Assert<T> {
    final T actual;

    Assert(T actual) {
        this.actual = actual;
    }

    public final void isNull() {
        Fail.failIfNotNull(this.actual);
    }

    Assert<T> isNotNull() {
        Fail.failIfNull(this.actual);
        return this;
    }

    Assert<T> isSameAs(T expected) {
        Fail.failIfNotSame(this.actual, expected);
        return this;
    }

    Assert<T> isNotSameAs(T expected) {
        Fail.failIfSame(this.actual, expected);
        return this;
    }

    Assert<T> isEqualTo(T expected) {
        Fail.failIfNotEqual(this.actual, expected);
        return this;
    }

    Assert<T> isNotEqualTo(T obj) {
        Fail.failIfEqual(this.actual, obj);
        return this;
    }
}

