/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util.rest;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.mortbay.log.Log;

public class FilenameGuardFilter
implements Filter {
    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            GuardedHttpServletRequest guardedRequest = new GuardedHttpServletRequest(httpRequest);
            chain.doFilter((ServletRequest)guardedRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private static class GuardedHttpServletRequest
    extends HttpServletRequestWrapper {
        public GuardedHttpServletRequest(HttpServletRequest httpRequest) {
            super(httpRequest);
        }

        private String guard(String filename) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("GUARDed " + filename + " to " + filename.replace(":", "_")));
            }
            return filename.replace(":", "_");
        }

        public String getParameter(String name) {
            if (name.equals("Destination")) {
                return this.guard(super.getParameter(name));
            }
            return super.getParameter(name);
        }

        public String getPathInfo() {
            return this.guard(super.getPathInfo());
        }

        public String getPathTranslated() {
            return this.guard(super.getPathTranslated());
        }

        public String getRequestURI() {
            return this.guard(super.getRequestURI());
        }
    }
}

