/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.util.MemUtil;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.h2.tools.Server;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class Manager
extends MonitoredNodeBase
implements MessagingListener {
    private final Logger logger;
    private JdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertJobTemplate;
    private static final String DATABASE = "database/chipster-manager";
    private static final boolean START_WEB_CONSOLE = true;
    private static final String DB_USERNAME = "chipster";
    private static final String DB_PASSWORD = "";
    private static final String CREATE_JOBS_TABLE = "CREATE TABLE IF NOT EXISTS jobs (jobId VARCHAR(100), operation VARCHAR(100), status VARCHAR(20), starttime DATETIME DEFAULT NULL, endtime DATETIME DEFAULT NULL, wallclockTime INT DEFAULT NULL, errorMessage TEXT DEFAULT NULL, outputText TEXT DEFAULT NULL, username VARCHAR(20), compHost VARCHAR(50));";
    private MessagingEndpoint endpoint;

    public Manager() throws MicroarrayException, JMSException, IOException, ConfigurationLoader.OldConfigurationFormatException, ClassNotFoundException, SQLException {
        MicroarrayConfiguration.loadConfiguration();
        this.logger = Logger.getLogger(Manager.class);
        this.logger.info((Object)"Starting manager...");
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.h2.Driver");
        dataSource.setUrl("jdbc:h2:database/chipster-manager");
        dataSource.setUsername(DB_USERNAME);
        dataSource.setPassword(DB_PASSWORD);
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        this.insertJobTemplate = new SimpleJdbcInsert((DataSource)dataSource).withTableName("jobs");
        this.jdbcTemplate.execute(CREATE_JOBS_TABLE);
        this.endpoint = new MessagingEndpoint(this);
        MessagingTopic managerTopic = this.endpoint.createTopic(Topics.Name.MANAGER_TOPIC, MessagingTopic.AccessMode.READ);
        managerTopic.setListener(this);
        Server server = Server.createWebServer((String[])new String[]{"-webAllowOthers"});
        server.start();
        this.logger.error((Object)("manager is up and running [" + ApplicationConstants.NAMI_VERSION + "]"));
        this.logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
    }

    public String getName() {
        return "manager";
    }

    public void onNamiMessage(NamiMessage namiMessage) {
        if (!(namiMessage instanceof JobLogMessage)) {
            this.logger.warn((Object)("Got other than JobLogMessage: " + namiMessage.toString()));
            return;
        }
        JobLogMessage jobLogMessage = (JobLogMessage)namiMessage;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobId", jobLogMessage.getJobId());
        parameters.put("operation", jobLogMessage.getOperation());
        parameters.put("status", jobLogMessage.getState().toString());
        parameters.put("starttime", jobLogMessage.getStartTime());
        parameters.put("endtime", jobLogMessage.getEndTime());
        parameters.put("wallclockTime", (jobLogMessage.getEndTime().getTime() - jobLogMessage.getStartTime().getTime()) / 1000L);
        parameters.put("errorMessage", jobLogMessage.getErrorMessage());
        parameters.put("outputText", jobLogMessage.getOutputText());
        parameters.put("username", jobLogMessage.getUsername());
        parameters.put("compHost", jobLogMessage.getCompHost());
        this.insertJobTemplate.execute(parameters);
    }
}

