/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.fs.FSDataBean;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.jms.JMSException;
import javax.swing.Icon;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class FSDataManagerTest {
    @BeforeSuite
    public void init() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
    }

    @Test
    public void testFSDataManagerInitialisation() throws IOException {
        new FSDataManager();
    }

    @Test
    public void testSnapshot() throws IOException, MicroarrayException {
        int dataCount;
        FSDataManager manager1 = new FSDataManager();
        String beanName1 = "My bean.txt";
        String beanName2 = "My other bean.txt";
        String beanName3 = "My other bean.txt";
        DataBean bean1 = manager1.createDataBean(beanName1);
        DataBean bean2 = manager1.createDataBean(beanName2);
        DataBean bean3 = manager1.createDataBean(beanName3);
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        manager1.getRootFolder().addChild(bean1);
        manager1.getRootFolder().addChild(bean2);
        manager1.getRootFolder().addChild(bean3);
        File snap = new File("temp-snapshot");
        if (snap.exists()) {
            Files.delTree(snap);
        }
        Assert.assertTrue(((dataCount = manager1.saveSnapshot(snap, new DummyClientApplication())) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)snap.exists());
        FSDataManager manager2 = new FSDataManager();
        manager2.loadSnapshot(snap, manager2.getRootFolder(), new DummyClientApplication());
        DataFolder root1 = manager1.getRootFolder();
        DataFolder root2 = manager2.getRootFolder();
        Assert.assertEquals((String)root2.toStringRecursively(0), (String)root1.toStringRecursively(0));
        DataBean newBean1 = null;
        for (DataItem item : root2.getChildren()) {
            if (!item.getName().equals(beanName1)) continue;
            newBean1 = (DataBean)item;
            break;
        }
        Assert.assertNotNull((Object)newBean1.getContentByteStream());
        Assert.assertEquals((int)newBean1.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)1);
    }

    @Test
    public void testDataBeanCreation() throws IOException, MicroarrayException {
        FSDataManager manager = new FSDataManager();
        FSDataBean bean = manager.createDataBean("neppari.txt", new FileInputStream("examples/affy_example.cel"));
        BufferedInputStream originalData = new BufferedInputStream(new FileInputStream("examples/affy_example.cel"));
        BufferedInputStream beanData = new BufferedInputStream(bean.getContentByteStream());
        Assert.assertTrue((boolean)Files.equalInputStreamContent(originalData, beanData));
        manager.createDataBean("neppari.txt", new FileInputStream("examples/affy_example.cel"));
        manager.createDataBean("neppari.txt", new FileInputStream("examples/affy_example.cel"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyClientApplication
    extends ClientApplication {
        private DummyClientApplication() {
        }

        @Override
        public OperationDefinition locateOperationDefinition(String categoryName, String operationName) {
            return new OperationDefinition("name", new OperationCategory("cat. name"), "description", false);
        }

        @Override
        public void createLink(DataBean source, DataBean target, DataBean.Link type) {
        }

        @Override
        public void deleteData(DataItem data, boolean confirmBeforeActing) {
        }

        @Override
        public void deleteDatas(List<DataBean> datas, boolean confirmBeforeActing) {
        }

        @Override
        public void flipTaskListVisibility(boolean closeIfVisible) {
        }

        @Override
        protected AuthenticationRequestListener getAuthenticationRequestListener() {
            return null;
        }

        @Override
        public Icon getIconFor(DataItem data) {
            return null;
        }

        @Override
        public void heartBeat() {
        }

        @Override
        public DataBean importData(String dataSetName, ContentType contentType, String folderName, Object dataSource, DataBean groupMember) {
            return null;
        }

        @Override
        public void loadSnapshot() {
        }

        @Override
        public File openWorkflow() {
            return null;
        }

        @Override
        public void removeLink(DataBean source, DataBean target, DataBean.Link type) {
        }

        @Override
        public void reportException(Exception e) {
        }

        @Override
        public void reportInitialisation(String report, boolean newline) {
        }

        @Override
        public void reportTaskError(Task job) throws MicroarrayException {
        }

        @Override
        public void saveSnapshot() {
        }

        @Override
        public File saveWorkflow() {
            return null;
        }

        @Override
        public void setBusyMode(boolean busy) {
        }

        @Override
        public void showDetailsFor(DataBean data) {
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal) {
        }

        @Override
        public void showDialog(String title, String message, String details, DialogInfo.Severity severity, boolean modal, ChipsterDialog.DetailsVisibility detailsVisibility) {
        }

        @Override
        public void showHistoryScreenFor(DataBean data) {
        }

        @Override
        public void showImportToolFor(File file, String destinationFolder, boolean skipActionChooser) {
        }

        @Override
        public void showPopupMenuFor(MouseEvent e, DataItem data) {
        }

        @Override
        public void showPopupMenuFor(MouseEvent e, List<DataItem> datas) {
        }

        @Override
        public void showSourceFor(String operationName) throws TaskException {
        }

        @Override
        protected void taskCountChanged(int newTaskCount, boolean attractAttention) {
        }

        @Override
        public void viewHelp(String id) {
        }

        @Override
        public void viewHelpFor(OperationDefinition operationDefinition) {
        }

        public void onException(JMSException arg0) {
        }

        @Override
        public DataManager getDataManager() {
            return null;
        }

        @Override
        public DataFolder initializeFolderForImport(String string) {
            return null;
        }

        @Override
        public VisualisationFrameManager getVisualisationFrameManager() {
            return null;
        }

        @Override
        public void setMaximisedVisualisationMode(boolean maximisedVisualisationMode) {
        }

        @Override
        public void visualiseWithBestMethod(VisualisationFrameManager.FrameType target) {
        }

        @Override
        public void importGroup(Collection<ImportItem> datas, String folderName) {
        }

        @Override
        public void runBlockingTask(String taskName, Runnable runnable) {
        }
    }
}

