/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.features;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.ModulesForTesting;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FeatureTest {
    private DataManager manager;

    public FeatureTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        this.manager = new FSDataManager();
        ModulesForTesting.getModulesForTesting().plugFeatures(this.manager);
    }

    @Test(groups={"smoke"})
    public void testEmbeddedBinary() throws IOException, MicroarrayException {
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        DataBean binAffyMicroarray = this.manager.createDataBean("bin_affy.cel", this.getClass().getResourceAsStream("/binary_affy_example.cel"));
        Assert.assertFalse((boolean)affyMicroarray.queryFeatures("/embedded-binary-content/").exists());
        Assert.assertTrue((boolean)binAffyMicroarray.queryFeatures("/embedded-binary-content/").exists());
    }

    @Test(groups={"smoke"})
    public void testPhenodataFeatures() throws IOException, MicroarrayException {
        DataBean data = this.manager.createDataBean("filtered.tsv", this.getClass().getResourceAsStream("/4_chips_filtered.tsv"));
        DataBean phenoData = this.manager.createDataBean("phenodata.tsv", this.getClass().getResourceAsStream("/4_chips_phenodata.tsv"));
        phenoData.addLink(DataBean.Link.ANNOTATION, data);
        Assert.assertTrue((boolean)phenoData.queryFeatures("/phenodata/").exists());
        Assert.assertTrue((boolean)phenoData.queryFeatures("/phenodata/is_complete").exists());
        Assert.assertEquals((String)phenoData.queryFeatures("/phenodata/sample_to_name/microarray1.cel").asString(), (String)"GSM11814.cel");
        Assert.assertEquals((String)phenoData.queryFeatures("/phenodata/sample_to_name/not_in_phenodata").asString(), (String)"not_in_phenodata");
        Assert.assertTrue((boolean)data.queryFeatures("/phenodata/linked/").exists());
        Assert.assertTrue((boolean)data.queryFeatures("/phenodata/linked/is_complete").exists());
    }

    @Test(groups={"smoke"})
    public void testModifiers() throws IOException, MicroarrayException {
        float f;
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        QueryResult feature = affyMicroarray.queryFeatures("log(/normalised-expression)");
        Assert.assertTrue((boolean)feature.exists());
        float last = 1.0f;
        Iterator<Float> i$ = feature.asFloats().iterator();
        while (i$.hasNext()) {
            last = f = i$.next().floatValue();
        }
        i$ = feature.asFloats().iterator();
        while (i$.hasNext()) {
            last = f = i$.next().floatValue();
        }
        Assert.assertEquals((Object)Float.valueOf(last), (Object)Float.valueOf(7.426265f));
        QueryResult doubleFeature = affyMicroarray.queryFeatures("log(log(/normalised-expression))");
        Assert.assertTrue((boolean)doubleFeature.exists());
    }

    public static void main(String[] args) throws IOException, MicroarrayException, ConfigurationLoader.OldConfigurationFormatException {
        new FeatureTest().testRowCount();
    }

    @Test(groups={"smoke"})
    public void testRowCount() throws MicroarrayException {
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        Assert.assertEquals((Object)affyMicroarray.queryFeatures("/rowcount/max/10").asFloat(), (Object)Float.valueOf(10.0f));
        Assert.assertEquals((Object)affyMicroarray.queryFeatures("/rowcount/max/1000000").asFloat(), (Object)Float.valueOf(15876.0f));
    }

    @Test(groups={"smoke"})
    public void testTableColumnIterable() throws MicroarrayException {
        Iterable[] iterables;
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        QueryResult mean = affyMicroarray.queryFeatures("/column/MEAN");
        for (Iterable iterable : iterables = new Iterable[]{mean.asFloats(), mean.asStrings()}) {
            Iterator iterator = iterable.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    @Test(groups={"smoke"})
    public void testFeatures() throws MicroarrayException, IOException {
        DataBean affyMicroarray = this.manager.createDataBean("affy.cel", this.getClass().getResourceAsStream("/affy_example.cel"));
        for (String feature : new String[]{"/normalised-expression", "/column/MEAN"}) {
            Assert.assertNotNull(affyMicroarray.queryFeatures(feature).asFloats(), (String)("error in " + feature));
            for (float f : affyMicroarray.queryFeatures(feature).asFloats()) {
                Assert.assertTrue(((double)f > 0.0 ? 1 : 0) != 0, (String)("illegal value: " + f + " in " + feature));
            }
        }
        Assert.assertTrue((affyMicroarray.queryFeatures("/column/MEAN").asFloats().iterator().next().floatValue() == 190.0f ? 1 : 0) != 0);
        float last = 0.0f;
        Iterator<Float> i$ = affyMicroarray.queryFeatures("/column/MEAN").asFloats().iterator();
        while (i$.hasNext()) {
            float f;
            last = f = i$.next().floatValue();
        }
        Assert.assertTrue((last == 172.0f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)VisualisationMethod.ARRAY_LAYOUT.isApplicableTo(affyMicroarray));
        DataBean somData = this.manager.createDataBean("som.tsv", this.getClass().getResourceAsStream("/som.tsv"));
        Assert.assertTrue((boolean)VisualisationMethod.SOM.isApplicableTo(somData));
        Table som = somData.queryFeatures("/clusters/som").asTable();
        Assert.assertNotNull((Object)som);
        Assert.assertEquals((int)som.getColumnCount(), (int)5);
        DataBean hcTree = this.manager.createDataBean("hs.txt", this.getClass().getResourceAsStream("/hc.txt"));
        DataBean hcHeatmap = this.manager.createDataBean("hc.tsv", this.getClass().getResourceAsStream("/hc-normalized.tsv"));
        hcTree.addLink(DataBean.Link.DERIVATION, hcHeatmap);
        Assert.assertTrue((boolean)VisualisationMethod.HIERARCHICAL.isApplicableTo(hcTree));
        Table heatmap = hcTree.queryFeatures("/clusters/hierarchical/heatmap").asTable();
        Assert.assertNotNull((Object)heatmap);
        heatmap.nextRow();
        Assert.assertNotNull((Object)heatmap.getValue(" "));
        String tree = hcTree.queryFeatures("/clusters/hierarchical/tree").asStrings().iterator().next();
        Assert.assertNotNull((Object)tree);
    }
}

