/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.DataModel;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import fi.csc.microarray.client.visualisation.methods.threed.Matrix;
import java.util.concurrent.PriorityBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projection {
    DataModel dataModel;
    private double xAxisRotation = Math.PI;
    private double yAxisRotation = 0.0;
    private double zAxisRotation = 0.0;
    private double distanceOfProjectionPlaneFromCamera = 15.0;
    private double viewWindowWidth = 5.0;
    private double viewWindowHeight = 5.0;
    private double[] camera = new double[]{0.0, 0.0, -5.0};
    private double[] newOrigin = new double[]{0.5, 0.5, 0.5};
    private PriorityBlockingQueue<Drawable> resultPoints = null;

    public Projection(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public double getXAxisRotation() {
        return this.xAxisRotation;
    }

    public void setXAxisRotation(double xAxisRotation) {
        this.xAxisRotation = xAxisRotation;
    }

    public double getYAxisRotation() {
        return this.yAxisRotation;
    }

    public void setYAxisRotation(double yAxisRotation) {
        this.yAxisRotation = yAxisRotation;
    }

    public double getZAxisRotation() {
        return this.zAxisRotation;
    }

    public void setZAxisRotation(double zAxisRotation) {
        this.zAxisRotation = zAxisRotation;
    }

    public double getDistanceOfProjectionPlaneFromOrigin() {
        return this.distanceOfProjectionPlaneFromCamera;
    }

    public void setDistanceOfProjectionPlaneFromOrigin(double distanceOfProjectionPlaneFromOrigin) {
        this.distanceOfProjectionPlaneFromCamera = distanceOfProjectionPlaneFromOrigin;
    }

    public double getViewWindowWidth() {
        return this.viewWindowWidth;
    }

    public void setViewWindowWidth(double viewWindowWidth) {
        this.viewWindowWidth = viewWindowWidth;
    }

    public double getViewWindowHeight() {
        return this.viewWindowHeight;
    }

    public void setViewWindowHeight(double viewWindowHeight) {
        this.viewWindowHeight = viewWindowHeight;
    }

    public double[] getPointOfView() {
        return this.camera;
    }

    public void setPointOfView(double[] pointOfView) {
        this.camera = pointOfView;
    }

    public double[] getNewOrigin() {
        return this.newOrigin;
    }

    public void setNewOrigin(double[] newOrigin) {
        this.newOrigin[0] = newOrigin[0];
        this.newOrigin[1] = newOrigin[1];
        this.newOrigin[2] = newOrigin[2];
    }

    public PriorityBlockingQueue<Drawable> getResultPoints() {
        return this.resultPoints;
    }

    private Matrix xAxisRotationMatrix(double degree) {
        double cosDegree = Math.cos(degree);
        double sinDegree = Math.sin(degree);
        Matrix m = new Matrix(4, 4, 0.0);
        m.set(1, 1, cosDegree);
        m.set(2, 2, cosDegree);
        m.set(1, 2, -sinDegree);
        m.set(2, 1, sinDegree);
        m.set(0, 0, 1.0);
        m.set(3, 3, 1.0);
        return m;
    }

    private Matrix yAxisRotationMatrix(double degree) {
        double cosDegree = Math.cos(degree);
        double sinDegree = Math.sin(degree);
        Matrix m = new Matrix(4, 4, 0.0);
        m.set(0, 0, cosDegree);
        m.set(2, 2, cosDegree);
        m.set(2, 0, -sinDegree);
        m.set(0, 2, sinDegree);
        m.set(1, 1, 1.0);
        m.set(3, 3, 1.0);
        return m;
    }

    private Matrix zAxisRotationMatrix(double degree) {
        double cosDegree = Math.cos(degree);
        double sinDegree = Math.sin(degree);
        Matrix m = new Matrix(4, 4, 0.0);
        m.set(0, 0, cosDegree);
        m.set(1, 1, cosDegree);
        m.set(0, 1, -sinDegree);
        m.set(1, 0, sinDegree);
        m.set(2, 2, 1.0);
        m.set(3, 3, 1.0);
        return m;
    }

    private Matrix translatePointToOriginMatrix(double[] point) {
        Matrix m = new Matrix(4, 4, 0.0);
        m.set(0, 0, 1.0);
        m.set(1, 1, 1.0);
        m.set(2, 2, 1.0);
        m.set(3, 3, 1.0);
        m.set(0, 3, -point[0]);
        m.set(1, 3, -point[1]);
        m.set(2, 3, -point[2]);
        return m;
    }

    private Matrix perspectiveProjectionMatrix(double planeDistance) {
        Matrix m = new Matrix(4, 4, 0.0);
        m.set(0, 0, 1.0);
        m.set(1, 1, 1.0);
        m.set(2, 2, 1.0);
        m.set(3, 2, 1.0 / planeDistance);
        return m;
    }

    private void homogeneousPointToProjectionPlanePoint(Matrix m, double[] p) {
        double w = m.get(3, 0);
        p[0] = m.get(0, 0) / w;
        p[1] = m.get(1, 0) / w;
    }

    public PriorityBlockingQueue<Drawable> doProjection() {
        Matrix projM = this.perspectiveProjectionMatrix(this.distanceOfProjectionPlaneFromCamera);
        projM = projM.times(this.translatePointToOriginMatrix(this.camera));
        Matrix rotM = this.zAxisRotationMatrix(this.zAxisRotation);
        rotM = rotM.times(this.xAxisRotationMatrix(this.xAxisRotation));
        rotM = rotM.times(this.yAxisRotationMatrix(this.yAxisRotation));
        rotM = rotM.times(this.translatePointToOriginMatrix(this.newOrigin));
        Drawable[] points = this.dataModel.getDataArray();
        this.resultPoints = new PriorityBlockingQueue(points.length);
        for (int i = 0; i < points.length; ++i) {
            boolean visible = this.rotateAndProject(points[i], rotM, projM, this.camera, this.distanceOfProjectionPlaneFromCamera, this.viewWindowWidth, this.viewWindowHeight);
            if (!visible || points[i] == null) continue;
            this.resultPoints.add(points[i]);
        }
        return this.resultPoints;
    }

    private boolean rotateAndProject(Drawable d, Matrix rot, Matrix proj, double[] cam, double planeDist, double viewW, double viewH) {
        Matrix point = new Matrix(4, 1, 1.0);
        boolean visible = false;
        for (int i = 0; i < d.visualisationCoords.length; ++i) {
            d.visualisationCoords[i][0] = d.dataCoords[i][0];
            d.visualisationCoords[i][1] = d.dataCoords[i][1];
            d.visualisationCoords[i][2] = d.dataCoords[i][2];
            point.set(0, 0, d.visualisationCoords[i][0]);
            point.set(1, 0, d.visualisationCoords[i][1]);
            point.set(2, 0, d.visualisationCoords[i][2]);
            point = rot.times(point);
            d.visualisationCoords[i][0] = point.get(0, 0);
            d.visualisationCoords[i][1] = point.get(1, 0);
            d.visualisationCoords[i][2] = point.get(2, 0);
            point = proj.times(point);
            this.homogeneousPointToProjectionPlanePoint(point, d.projectedCoords[i]);
            double[] dArray = d.projectedCoords[i];
            dArray[0] = dArray[0] / viewW;
            double[] dArray2 = d.projectedCoords[i];
            dArray2[1] = dArray2[1] / viewH;
            if (d.visualisationCoords[i][2] > this.camera[2]) {
                visible = true;
            }
            point.set(3, 0, 1.0);
        }
        d.setDistanceFromCamera(cam, planeDist, viewW, viewH);
        return visible;
    }
}

