/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.methods.PositionRecordingRenderer;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.OverlayLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Volcanoplot
extends Scatterplot
implements ActionListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private static final String Y_AXIS_EXPRESSION = "neg(log(/column/p.*))";
    private static final String X_AXIS_EXPRESSION = "/column/FC";

    public Volcanoplot(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        if (this.chartPanel != null) {
            this.chartPanel.setVisible(false);
        }
        this.allItems.clear();
        Iterable<Float> xValues = data.queryFeatures(X_AXIS_EXPRESSION).asFloats();
        Iterable<Float> yValues = data.queryFeatures(Y_AXIS_EXPRESSION).asFloats();
        int i = 0;
        for (String name : data.queryFeatures("/column/ ").asStrings()) {
            this.allItems.add(new Scatterplot.DataItem2D(null, name, i++));
        }
        Visualisation.PlotDescription description = new Visualisation.PlotDescription(data.getName(), "fold change", "-log(p)");
        XYSeries redSeries = this.filterXYSeries(xValues, yValues, 3.0f, 1.0f, true);
        XYSeries blackSeries = this.filterXYSeries(xValues, yValues, 2.0f, 1.0f, false);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(redSeries);
        dataset.addSeries(blackSeries);
        NumberAxis domainAxis = new NumberAxis(description.xTitle);
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis(description.yTitle);
        rangeAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, null);
        JFreeChart chart = new JFreeChart(description.plotTitle, (Plot)plot);
        this.chartPanel = this.makePanel(chart);
        this.chartPanel.addMouseListener((MouseListener)this);
        this.chartPanel.addMouseMotionListener((MouseMotionListener)this);
        this.chartPanel.setMouseZoomable(false);
        PositionRecordingRenderer renderer = new PositionRecordingRenderer(1, this.allItems, this.selectedItems, this.chartPanel);
        plot.setRenderer((XYItemRenderer)renderer);
        this.overlayPanel = new JPanel((LayoutManager)new OverlayLayout());
        this.transparentPanel = new Scatterplot.TransparentPanel();
        this.overlayPanel.add(this.transparentPanel);
        this.overlayPanel.add((Component)this.chartPanel);
        this.updateSelectionsFromApplication(false);
        this.application.addPropertyChangeListener(this);
        this.chartPanel.setVisible(true);
        return this.overlayPanel;
    }

    protected XYSeries filterXYSeries(Iterable<Float> xValues, Iterable<Float> yValues, float xThreshold, float yThreshold, boolean reversed) {
        XYSeries series = new XYSeries((Comparable)((Object)""), false);
        Iterator<Float> xIterator = xValues.iterator();
        for (Float y : yValues) {
            Float x = xIterator.next();
            boolean overThresholds = Math.abs(x.floatValue()) >= xThreshold && y.floatValue() >= yThreshold;
            if (!(overThresholds ^ reversed)) continue;
            series.add((Number)x, (Number)y);
        }
        return series;
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return false;
    }
}

