/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.methods.VenndiPlot;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VennDiagram
extends Visualisation
implements PropertyChangeListener {
    private VenndiPlot plot;
    private ChartPanel chartPanel;
    private JPanel paramPanel;
    private AnnotateListPanel list;

    public VennDiagram(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.paramPanel.setLayout(new BorderLayout());
            this.list = new AnnotateListPanel();
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Selected", this.list);
            this.paramPanel.add((Component)tabPane, "Center");
        }
        return this.paramPanel;
    }

    @Override
    public JComponent getVisualisation(List<DataBean> datas) throws Exception {
        if (datas.size() < 2 || datas.size() > 3) {
            throw new IllegalArgumentException("Venn Diagram can be used only with two or three datasets");
        }
        HashMap<String, Integer> A = new HashMap<String, Integer>();
        HashMap<String, Integer> B = new HashMap<String, Integer>();
        HashMap<String, Integer> C = new HashMap<String, Integer>();
        int i = 0;
        for (String name : datas.get(0).queryFeatures("/column/ ").asStrings()) {
            A.put(name, i++);
        }
        i = 0;
        for (String name : datas.get(1).queryFeatures("/column/ ").asStrings()) {
            B.put(name, i++);
        }
        i = 0;
        if (datas.size() == 3) {
            for (String name : datas.get(2).queryFeatures("/column/ ").asStrings()) {
                C.put(name, i++);
            }
        }
        HashMap sortedIds = new HashMap(VenndiPlot.AREAS.values().length);
        for (VenndiPlot.AREAS area : VenndiPlot.AREAS.values()) {
            sortedIds.put(area, new HashSet());
        }
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.ABC)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.ABC)).retainAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.ABC)).retainAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AB)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AB)).retainAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AB)).removeAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.BC)).addAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.BC)).retainAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.BC)).removeAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AC)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AC)).retainAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.AC)).removeAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.A)).addAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.A)).removeAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.A)).removeAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.B)).addAll(B.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.B)).removeAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.B)).removeAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.C)).addAll(C.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.C)).removeAll(A.keySet());
        ((Set)sortedIds.get((Object)VenndiPlot.AREAS.C)).removeAll(B.keySet());
        String[][] idTable = new String[VenndiPlot.AREAS.values().length][];
        for (VenndiPlot.AREAS area : VenndiPlot.AREAS.values()) {
            idTable[area.ordinal()] = ((Set)sortedIds.get((Object)area)).toArray(new String[0]);
        }
        HashMap<DataBean, Map<String, Integer>> indexMaps = new HashMap<DataBean, Map<String, Integer>>();
        indexMaps.put(datas.get(0), A);
        indexMaps.put(datas.get(1), B);
        if (datas.size() > 2) {
            indexMaps.put(datas.get(2), C);
        }
        this.plot = new VenndiPlot(idTable, datas, indexMaps, this);
        this.chartPanel = this.makePanel(new JFreeChart("Venn-diagram", (Plot)this.plot));
        this.chartPanel.addChartMouseListener((ChartMouseListener)this.plot);
        this.updateSelectionsFromApplication(false);
        this.application.addPropertyChangeListener(this);
        return this.chartPanel;
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return false;
    }

    @Override
    public boolean canVisualise(List<DataBean> beans) throws MicroarrayException {
        if (beans.size() < 2 || beans.size() > 3) {
            return false;
        }
        for (DataBean data : beans) {
            boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(data);
            if (isTabular && data.queryFeatures("/column/chip.*").exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isForSingleData() {
        return false;
    }

    @Override
    public boolean isForMultipleDatas() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof RowChoiceEvent && evt.getSource() != this) {
            this.updateSelectionsFromApplication(false);
        }
    }

    private void updateSelectionsFromApplication(boolean dispatchEvent) {
        ArrayList<String> selected = new ArrayList<String>();
        try {
            for (DataBean data : this.plot.getDataset().getDataBeans()) {
                RowSelectionManager manager = this.application.getSelectionManager().getRowSelectionManager(data);
                selected.addAll(manager.getSelectedIdentifiers());
            }
        }
        catch (MicroarrayException e) {
            this.application.reportException(new MicroarrayException("Unable to get selected identifiers", e));
        }
        this.plot.setSelected(selected);
        this.plot.setSelectedForList(false);
        this.chartPanel.repaint();
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        throw new MicroarrayException("Venn Diagram can be used only with two or three datasets");
    }

    public void setSelectedListContent(List<String> ids, Map<DataBean, Set<Integer>> indexes, VenndiPlot venndiPlot, boolean dispatchEvent) {
        this.list.setSelectedListContentMultipleDatas(ids, indexes, this, dispatchEvent);
    }
}

