/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.ChipVisualisation;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.methods.PositionRecordingRenderer;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.OverlayLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scatterplot
extends ChipVisualisation
implements ActionListener,
MouseListener,
MouseMotionListener,
PropertyChangeListener {
    protected ChartPanel chartPanel;
    protected JPanel paramPanel;
    protected JPanel settingsPanel;
    protected JPanel overlayPanel;
    protected AnnotateListPanel list;
    protected JComboBox xBox;
    protected JComboBox yBox;
    protected DataBean data;
    protected JButton useButton;
    protected List<DataItem2D> allItems = new LinkedList<DataItem2D>();
    protected Set<DataItem2D> selectedItems = new HashSet<DataItem2D>();
    protected TransparentPanel transparentPanel;
    private Point startCoords;
    private boolean isDragged = false;

    public Scatterplot(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.paramPanel.setLayout(new BorderLayout());
            JPanel settings = this.createSettingsPanel();
            this.list = new AnnotateListPanel();
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Settings", settings);
            tabPane.addTab("Selected", this.list);
            this.paramPanel.add((Component)tabPane, "Center");
        }
        return this.paramPanel;
    }

    public JPanel createSettingsPanel() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new GridBagLayout());
        this.settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.xBox = new JComboBox();
        this.yBox = new JComboBox();
        this.useButton = new JButton("Draw");
        this.useButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 10, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.settingsPanel.add((Component)new JLabel("X-axis: "), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.xBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)new JLabel("Y-axis: "), c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.yBox, c);
        ++c.gridy;
        this.settingsPanel.add((Component)this.useButton, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.settingsPanel.add((Component)new JPanel(), c);
        this.xBox.addActionListener(this);
        this.yBox.addActionListener(this);
        return this.settingsPanel;
    }

    protected void refreshAxisBoxes(DataBean data) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        Visualisation.fillCompoBox(this.xBox, this.getVariablesFor(data));
        Visualisation.fillCompoBox(this.yBox, this.getVariablesFor(data));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useButton) {
            ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
            vars.add((Visualisation.Variable)this.xBox.getSelectedItem());
            vars.add((Visualisation.Variable)this.yBox.getSelectedItem());
            this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.SCATTERPLOT, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
        }
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        if (this.chartPanel != null) {
            this.chartPanel.setVisible(false);
        }
        this.allItems.clear();
        this.refreshAxisBoxes(data);
        List<Visualisation.Variable> vars = this.getFrame().getVariables();
        if (vars == null || vars.size() < 2) {
            if (this.xBox.getItemCount() >= 1) {
                this.xBox.setSelectedIndex(0);
            }
            if (this.yBox.getItemCount() >= 2) {
                this.yBox.setSelectedIndex(1);
            } else {
                this.yBox.setSelectedIndex(0);
            }
        } else {
            this.xBox.setSelectedItem(vars.get(0));
            this.yBox.setSelectedItem(vars.get(1));
        }
        Visualisation.Variable xVar = (Visualisation.Variable)this.xBox.getSelectedItem();
        Visualisation.Variable yVar = (Visualisation.Variable)this.yBox.getSelectedItem();
        Iterable<Float> xValues = data.queryFeatures(xVar.getExpression()).asFloats();
        Iterable<Float> yValues = data.queryFeatures(yVar.getExpression()).asFloats();
        int i = 0;
        for (String name : data.queryFeatures("/column/ ").asStrings()) {
            this.allItems.add(new DataItem2D(null, name, i++));
        }
        Visualisation.PlotDescription description = new Visualisation.PlotDescription(data.getName(), xVar.getName(), yVar.getName());
        XYSeries series = this.toXYSeries(xValues, yValues);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        NumberAxis domainAxis = new NumberAxis(description.xTitle);
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis(description.yTitle);
        rangeAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, null);
        JFreeChart chart = new JFreeChart(description.plotTitle, (Plot)plot);
        this.chartPanel = this.makePanel(chart);
        this.chartPanel.addMouseListener((MouseListener)this);
        this.chartPanel.addMouseMotionListener((MouseMotionListener)this);
        this.chartPanel.setMouseZoomable(false);
        PositionRecordingRenderer renderer = new PositionRecordingRenderer(1, this.allItems, this.selectedItems, this.chartPanel);
        plot.setRenderer((XYItemRenderer)renderer);
        this.overlayPanel = new JPanel((LayoutManager)new OverlayLayout());
        this.transparentPanel = new TransparentPanel();
        this.overlayPanel.add(this.transparentPanel);
        this.overlayPanel.add((Component)this.chartPanel);
        this.updateSelectionsFromApplication(false);
        this.application.addPropertyChangeListener(this);
        this.chartPanel.setVisible(true);
        return this.overlayPanel;
    }

    protected XYSeries toXYSeries(Iterable<Float> xValues, Iterable<Float> yValues) {
        XYSeries series = new XYSeries((Comparable)((Object)""), false);
        Iterator<Float> xIterator = xValues != null ? xValues.iterator() : null;
        int i = 0;
        for (Float y : yValues) {
            if (xIterator != null) {
                series.add((Number)xIterator.next(), (Number)y);
            } else {
                series.add((double)i, (Number)y);
            }
            ++i;
        }
        return series;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isControlDown()) {
            this.selectedItems.clear();
        }
        Rectangle2D r = null;
        for (DataItem2D item : this.allItems) {
            r = item.getBounds();
            if (!r.contains(e.getPoint()) || this.selectedItems.contains(item) || item == null) continue;
            this.selectedItems.add(item);
        }
        this.list.setSelectedListContentAsDataItems(this.selectedItems, this, true, this.data);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startCoords = e.getPoint();
        this.isDragged = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.transparentPanel.setArea(null);
        this.transparentPanel.repaint();
        if (this.isDragged) {
            if (!e.isControlDown()) {
                this.selectedItems.clear();
            }
            Rectangle2D r = null;
            int x = (int)this.startCoords.getX() < e.getX() ? (int)this.startCoords.getX() : e.getX();
            int y = (int)this.startCoords.getY() < e.getY() ? (int)this.startCoords.getY() : e.getY();
            int w = Math.abs(e.getX() - (int)this.startCoords.getX());
            int h = Math.abs(e.getY() - (int)this.startCoords.getY());
            Rectangle selectedArea = new Rectangle(x, y, w, h);
            for (DataItem2D item : this.allItems) {
                r = item.getBounds();
                if (!selectedArea.intersects(r)) continue;
                this.selectedItems.add(item);
            }
            this.list.setSelectedListContentAsDataItems(this.selectedItems, this, true, this.data);
        }
        this.chartPanel.getChart().fireChartChanged();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.isDragged = true;
        int x = (int)this.startCoords.getX() < e.getX() ? (int)this.startCoords.getX() : e.getX();
        int y = (int)this.startCoords.getY() < e.getY() ? (int)this.startCoords.getY() : e.getY();
        int w = Math.abs(e.getX() - (int)this.startCoords.getX());
        int h = Math.abs(e.getY() - (int)this.startCoords.getY());
        this.transparentPanel.setArea(new Rectangle(x, y, w, h));
        this.transparentPanel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof RowChoiceEvent && evt.getSource() != this && ((RowChoiceEvent)evt).getData() == this.data) {
            this.updateSelectionsFromApplication(false);
            this.chartPanel.repaint();
        }
    }

    protected void updateSelectionsFromApplication(boolean dispatchEvent) {
        RowSelectionManager manager = this.application.getSelectionManager().getRowSelectionManager(this.data);
        this.selectedItems.clear();
        int[] arr$ = manager.getSelectedRows();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer index = arr$[i$];
            DataItem2D point = this.allItems.get(index);
            if (point == null) continue;
            this.selectedItems.add(this.allItems.get(index));
        }
        this.list.setSelectedListContentAsDataItems(this.selectedItems, this, dispatchEvent, this.data);
    }

    protected class TransparentPanel
    extends JPanel {
        private Rectangle2D area;

        public TransparentPanel() {
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            super.paintComponents(g);
            if (this.area != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.DARK_GRAY);
                g2d.setStroke(VisualConstants.dashLine);
                g2d.draw(this.area);
            }
        }

        protected void setArea(Rectangle area) {
            this.area = area;
        }
    }

    public class DataItem2D {
        private Rectangle2D bounds;
        private String name;
        private Integer index;

        public DataItem2D(Rectangle2D r, String n, int index) {
            this.bounds = r;
            this.name = n;
            this.index = index;
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public void setBounds(Rectangle rect) {
            this.bounds = rect;
        }

        public boolean equals(Object other) {
            return other instanceof DataItem2D && ((DataItem2D)other).getIndex() == this.getIndex();
        }

        public int hashCode() {
            return this.index.hashCode();
        }
    }
}

