/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.ModulesForTesting;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VisualiserTest {
    private DataManager manager;

    public VisualiserTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        this.manager = new FSDataManager();
        ModulesForTesting.getModulesForTesting().plugFeatures(this.manager);
    }

    public static void main(String[] args) throws IOException, Exception {
        new VisualiserTest().testHC();
    }

    @Test(groups={"smoke"})
    public void testSom() throws Exception {
        DataBean dataset = this.manager.createDataBean("SOM", this.getClass().getResourceAsStream("/som.tsv"));
        JComponent component = this.doVisualisation(VisualisationMethod.SOM, dataset);
        this.makeFrame(component);
    }

    @Test(groups={"smoke"})
    public void testHC() throws Exception {
        String[] trees = new String[]{"/hc.txt", "/illumina-hc.txt", "/agilent-hc.txt"};
        String[] heatmaps = new String[]{"/hc-normalized.tsv", "/illumina-hc-normalized.tsv", "/agilent-hc-normalized.tsv"};
        for (int i = 0; i < trees.length; ++i) {
            DataBean tree = this.manager.createDataBean("HC clusters", this.getClass().getResourceAsStream(trees[i]));
            DataBean heatmap = this.manager.createDataBean("heatmap", this.getClass().getResourceAsStream(heatmaps[i]));
            tree.addLink(DataBean.Link.DERIVATION, heatmap);
            JComponent component = VisualisationMethod.HIERARCHICAL.getHeadlessVisualiser().getVisualisation(tree);
            this.makeFrame(component);
        }
    }

    @Test(groups={"smoke"})
    public void testVisualisations() throws Exception {
        String[] resources;
        for (String resource : resources = new String[]{"/mouse1.tsv", "/resultset.tsv", "/affy_example.cel"}) {
            try {
                DataBean bean = this.manager.createDataBean(resource, this.getClass().getResourceAsStream(resource));
                this.doVisualisation(VisualisationMethod.ARRAY_LAYOUT, bean);
                this.doVisualisation(VisualisationMethod.SPREADSHEET, bean);
            }
            catch (Exception e) {
                System.err.println("exception when processing " + resource + ": " + e.getMessage());
                throw e;
            }
        }
    }

    @Test(groups={"smoke"})
    public void testScatterplot() throws Exception {
        for (String resource : new String[]{"/4_chips_filtered.tsv", "/ei_visualisoidu.tsv", "/ei_visualisoidu_2.tsv"}) {
            try {
                DataBean dataBean = this.manager.createDataBean(resource, this.getClass().getResourceAsStream(resource));
                VisualisationMethod.SCATTERPLOT.getHeadlessVisualiser().getVariablesFor(dataBean);
                VisualisationMethod.SCATTERPLOT.getHeadlessVisualiser().getParameterPanel();
                JComponent visualisation = VisualisationMethod.SCATTERPLOT.getHeadlessVisualiser().getVisualisation(dataBean);
                this.makeFrame(visualisation);
            }
            catch (Exception e) {
                System.err.println("exception when processing " + resource + ": " + e.getMessage());
                throw e;
            }
        }
    }

    @Test(groups={"smoke"})
    public void testHistogram() throws Exception {
        DataBean dataBean = this.manager.createDataBean("Hist. data", this.getClass().getResourceAsStream("/4_chips_filtered.tsv"));
        Visualisation.Variable[] variables = VisualisationMethod.HISTOGRAM.getHeadlessVisualiser().getVariablesFor(dataBean);
        Assert.assertEquals((int)variables.length, (int)4);
        Visualisation visualiser = VisualisationMethod.HISTOGRAM.getHeadlessVisualiser();
        visualiser.getParameterPanel();
        JComponent visualisation = visualiser.getVisualisation(dataBean);
        this.makeFrame(visualisation);
    }

    @Test(groups={"smoke"})
    public void testExpressionProfile() throws Exception {
        DataBean dataBean = this.manager.createDataBean("Profiledata", this.getClass().getResourceAsStream("/4_chips_filtered.tsv"));
        JComponent visualisation = VisualisationMethod.EXPRESSION_PROFILE.getHeadlessVisualiser().getVisualisation(dataBean);
        this.makeFrame(visualisation);
    }

    @Test(groups={"smoke"})
    public void testClusteredProfiles() throws Exception {
        DataBean dataBean = this.manager.createDataBean("Profiledata", this.getClass().getResourceAsStream("/kmeans.tsv"));
        JComponent visualisation = VisualisationMethod.CLUSTERED_PROFILES.getHeadlessVisualiser().getVisualisation(dataBean);
        this.makeFrame(visualisation);
    }

    @Test(groups={"smoke"})
    public void testApplicabilityChecks() throws MicroarrayException, IOException {
        DataBean affyMicroarray = this.manager.createDataBean("", this.getClass().getResourceAsStream("/affy_example.cel"));
        for (VisualisationMethod method : VisualisationMethod.values()) {
            if (!method.isApplicableTo(affyMicroarray) || method != VisualisationMethod.SOM && method != VisualisationMethod.HIERARCHICAL && method != VisualisationMethod.EXPRESSION_PROFILE && method != VisualisationMethod.SHOW_IMAGE && method != VisualisationMethod.WEBVIEW && method != VisualisationMethod.VIEW_TEXT) continue;
            Assert.fail((String)("method " + method.name() + " should not be applicable to " + affyMicroarray.getName()));
        }
    }

    private JComponent doVisualisation(VisualisationMethod method, DataBean bean) throws Exception {
        method.getHeadlessVisualiser().getParameterPanel();
        return method.getHeadlessVisualiser().getVisualisation(bean);
    }

    private void makeFrame(JComponent visualisation) {
        JFrame frame = new JFrame();
        frame.add(visualisation);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

