/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.selection;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.databeans.DataBean;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowSelectionManager {
    private ClientApplication client;
    private DataBean data;
    private int[] selectedRows = new int[0];

    public RowSelectionManager(ClientApplication client, DataBean data) {
        this.client = client;
        this.data = data;
    }

    public int[] getSelectedRows() {
        return (int[])this.selectedRows.clone();
    }

    public List<String> getSelectedIdentifiers() throws MicroarrayException {
        Arrays.sort(this.selectedRows);
        ArrayList<String> names = new ArrayList<String>(this.selectedRows.length);
        int i = 0;
        for (String name : this.data.queryFeatures("/column/ ").asStrings()) {
            if (Arrays.binarySearch(this.selectedRows, i) >= 0) {
                names.add(name);
            }
            ++i;
        }
        return names;
    }

    public List<String> getSelectedLines() throws Exception {
        String line;
        ArrayList<String> lines = new ArrayList<String>(this.selectedRows.length + 1);
        BufferedReader original = null;
        original = new BufferedReader(new InputStreamReader(this.data.getContentByteStream()));
        Arrays.sort(this.selectedRows);
        int i = 0;
        while ((line = original.readLine()) != null) {
            if (i == 0 || Arrays.binarySearch(this.selectedRows, i - 1) >= 0) {
                lines.add(line);
            }
            ++i;
        }
        if (original != null) {
            original.close();
        }
        return lines;
    }

    public static DataBean createDataset(Iterable<String> lines, DataBean ... sources) throws Exception {
        DataBean newData = Session.getSession().getApplication().getDataManager().createDataBean("user_edited.tsv");
        OutputStream outputStream = newData.getContentOutputStreamAndLockDataBean();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        for (String line : lines) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        newData.closeContentOutputStreamAndUnlockDataBean(outputStream);
        newData.setOperation(new Operation(OperationDefinition.USER_MODIFICATION_DEFINITION, new DataBean[]{newData}));
        DataBean primarySource = sources[0];
        newData.setContentType(primarySource.getContentType());
        for (DataBean data : sources) {
            newData.addLink(DataBean.Link.MODIFICATION, data);
        }
        primarySource.getParent().addChild(newData);
        return newData;
    }

    public void setSelected(int[] selected, Object source) {
        this.selectedRows = (int[])selected.clone();
        this.client.dispatchEvent(new RowChoiceEvent(this.data, source));
    }

    public void clearAll(Object source) {
        this.selectedRows = new int[0];
    }

    public void setSelected(Set<Integer> set, Object source) {
        set.remove(null);
        int[] indexes = new int[set.size()];
        int i = 0;
        for (Integer index : set) {
            if (index == null) continue;
            indexes[i++] = index;
        }
        this.selectedRows = indexes;
        this.client.dispatchEvent(new RowChoiceEvent(this.data, source));
    }
}

