/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationPanel;
import fi.csc.microarray.client.operation.parameter.DataSelectionParameter;
import fi.csc.microarray.client.operation.parameter.DecimalInputComponent;
import fi.csc.microarray.client.operation.parameter.DecimalParameter;
import fi.csc.microarray.client.operation.parameter.IntegerInputComponent;
import fi.csc.microarray.client.operation.parameter.IntegerParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.PercentageInputComponent;
import fi.csc.microarray.client.operation.parameter.PercentageParameter;
import fi.csc.microarray.client.operation.parameter.SingleSelectionInputComponent;
import fi.csc.microarray.client.operation.parameter.SingleSelectionParameter;
import fi.csc.microarray.client.operation.parameter.StringInputComponent;
import fi.csc.microarray.client.operation.parameter.StringParameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ParameterPanel
extends JPanel {
    private Map<Parameter, ParameterInputComponent> paramMap;
    private JScrollPane scroller;
    private OperationPanel parent;
    private static final int LEFT_MARGIN = 10;
    private static final int TOP_MARGIN = 2;

    public ParameterPanel(Operation operation, OperationPanel parent) throws MicroarrayException {
        super(new BorderLayout());
        this.parent = parent;
        JPanel paramPane = new JPanel(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.weightx = 1.0;
        con.weighty = 0.0;
        con.anchor = 17;
        this.paramMap = new HashMap<Parameter, ParameterInputComponent>();
        for (Parameter param : operation.getParameters()) {
            ParameterInputComponent component = this.createInputComponent(param);
            this.paramMap.put(param, component);
            con.gridx = 0;
            ++con.gridy;
            con.insets.top = 2;
            con.insets.left = 10;
            con.fill = 2;
            paramPane.add((Component)component.getLabel(), con);
            con.gridx = 1;
            con.anchor = 13;
            con.fill = 0;
            paramPane.add((Component)component, con);
        }
        con.weighty = 1.0;
        con.weightx = 0.0;
        con.gridx = 0;
        ++con.gridy;
        con.gridwidth = 2;
        con.fill = 1;
        paramPane.add((Component)new JPanel(), con);
        this.scroller = new JScrollPane(paramPane);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.OPERATION_LIST_BORDER_COLOR));
        this.add((Component)this.scroller, "Center");
    }

    private ParameterInputComponent createInputComponent(Parameter parameter) throws MicroarrayException {
        if (parameter instanceof IntegerParameter) {
            return new IntegerInputComponent((IntegerParameter)parameter, this);
        }
        if (parameter instanceof DecimalParameter) {
            return new DecimalInputComponent((DecimalParameter)parameter, this);
        }
        if (parameter instanceof PercentageParameter) {
            return new PercentageInputComponent((PercentageParameter)parameter, this);
        }
        if (parameter instanceof DataSelectionParameter) {
            return new SingleSelectionInputComponent((DataSelectionParameter)parameter, this);
        }
        if (parameter instanceof SingleSelectionParameter) {
            return new SingleSelectionInputComponent((SingleSelectionParameter)parameter, this);
        }
        if (parameter instanceof StringParameter) {
            return new StringInputComponent((StringParameter)parameter, this);
        }
        throw new IllegalArgumentException("The given Parameter object, " + parameter.getName() + ", was not of recognized type!");
    }

    public void setMessage(String message, Color color) {
        this.parent.setInfoText(message, color, true);
    }

    public OperationPanel getOperationPanel() {
        return this.parent;
    }
}

